/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lio/github/caijiang/common/util/UtilUtils;", "", "()V", "createUUIDFrom", "Ljava/util/UUID;", "bytes", "", "readBytesFrom", "uuid", "runInTest", "", "common-ext"})
public final class UtilUtils {
    @NotNull
    public static final UtilUtils INSTANCE = new UtilUtils();

    private UtilUtils() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] readBytesFrom(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        byte[] byArray = bb.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final UUID createUUIDFrom(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBuffer x = ByteBuffer.wrap(bytes);
        return new UUID(x.getLong(), x.getLong());
    }

    @JvmStatic
    public static final boolean runInTest() {
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNull((Object)traces);
        for (StackTraceElement element : traces) {
            String string = element.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"org.junit.", (boolean)false, (int)2, null)) {
                String string2 = element.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"org.testng.", (boolean)false, (int)2, null)) continue;
            }
            return true;
        }
        return false;
    }
}

