/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.nacos;

import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingMaintainFactory;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import io.github.caijiang.common.logging.LoggingApi;
import io.github.caijiang.common.nacos.AuthData;
import io.github.caijiang.common.nacos.NacosService;
import io.github.caijiang.common.nacos.NacosServiceKt;
import io.github.caijiang.common.nacos.ResourceLocator;
import io.github.caijiang.common.orchestration.IngressEntrance;
import io.github.caijiang.common.orchestration.Service;
import io.github.caijiang.common.orchestration.ServiceNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.logging.LogLevel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J;\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u0015\u00a2\u0006\u0002\b\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/github/caijiang/common/nacos/NacosService;", "Lio/github/caijiang/common/orchestration/IngressEntrance;", "serviceName", "", "locator", "Lio/github/caijiang/common/nacos/ResourceLocator;", "(Ljava/lang/String;Lio/github/caijiang/common/nacos/ResourceLocator;)V", "ingressName", "getIngressName", "()Ljava/lang/String;", "properties", "Ljava/util/Properties;", "changeInstance", "", "serviceNode", "Lio/github/caijiang/common/orchestration/ServiceNode;", "loggingApi", "Lio/github/caijiang/common/logging/LoggingApi;", "optional", "", "block", "Lkotlin/Function1;", "Lcom/alibaba/nacos/api/naming/pojo/Instance;", "Lkotlin/ExtensionFunctionType;", "checkWorkStatus", "node", "discoverNodes", "", "service", "Lio/github/caijiang/common/orchestration/Service;", "resumedNode", "suspendNode", "NacosServiceNode", "common-ext"})
@SourceDebugExtension(value={"SMAP\nNacosService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NacosService.kt\nio/github/caijiang/common/nacos/NacosService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1#2:129\n1549#3:130\n1620#3,3:131\n766#3:134\n857#3,2:135\n1747#3,3:137\n1549#3:140\n1620#3,3:141\n*S KotlinDebug\n*F\n+ 1 NacosService.kt\nio/github/caijiang/common/nacos/NacosService\n*L\n91#1:130\n91#1:131,3\n100#1:134\n100#1:135,2\n104#1:137,3\n112#1:140\n112#1:141,3\n*E\n"})
public final class NacosService
implements IngressEntrance {
    @NotNull
    private final String serviceName;
    @NotNull
    private final ResourceLocator locator;
    @NotNull
    private final Properties properties;

    /*
     * WARNING - void declaration
     */
    public NacosService(@NotNull String serviceName, @NotNull ResourceLocator locator) {
        Object it;
        void $this$properties_u24lambda_u243;
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        this.serviceName = serviceName;
        this.locator = locator;
        Properties properties2 = properties = new Properties();
        NacosService nacosService = this;
        boolean bl = false;
        ((Map)$this$properties_u24lambda_u243).put("serverAddr", this.locator.getServerAddr());
        String string = this.locator.getNamespaceId();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            ((Map)$this$properties_u24lambda_u243).put("namespace", it);
        }
        AuthData authData = this.locator.getAuth();
        if (authData != null) {
            it = authData;
            boolean bl3 = false;
            ((Map)$this$properties_u24lambda_u243).put("username", ((AuthData)it).getUsername());
            ((Map)$this$properties_u24lambda_u243).put("password", ((AuthData)it).getPassword());
        }
        if (this.locator.getAccessKey() != null && this.locator.getSecretKey() != null) {
            ((Map)$this$properties_u24lambda_u243).put("accessKey", this.locator.getAccessKey());
            ((Map)$this$properties_u24lambda_u243).put("secretKey", this.locator.getSecretKey());
        }
        String string2 = this.locator.getClusterName();
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            ((Map)$this$properties_u24lambda_u243).put("endpointClusterName", it);
        }
        nacosService.properties = properties;
    }

    @Override
    @NotNull
    public String getIngressName() {
        return "nacos";
    }

    private final void changeInstance(ServiceNode serviceNode, LoggingApi loggingApi, boolean optional, Function1<? super Instance, Unit> block) {
        Instance instance;
        Object object;
        Iterable iterable;
        List allInstances;
        block5: {
            allInstances = NamingFactory.createNamingService((Properties)this.properties).getAllInstances(this.serviceName);
            Intrinsics.checkNotNull((Object)allInstances);
            iterable = allInstances;
            for (Object object2 : iterable) {
                Instance it = (Instance)object2;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getIp(), (Object)serviceNode.getIp()) && it.getPort() == serviceNode.getPort())) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        if ((instance = (Instance)object) == null) {
            Object v2;
            block6: {
                Object object2;
                Iterable iterable2 = allInstances;
                object2 = iterable2.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    Instance it = (Instance)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getIp(), (Object)serviceNode.getIp())) continue;
                    v2 = e;
                    break block6;
                }
                v2 = null;
            }
            if ((instance = (Instance)v2) == null) {
                if (optional) {
                    LoggingApi.logMessage$default(loggingApi, LogLevel.WARN, "\u6ca1\u6709\u5728 nacos \u627e\u5230\u7b26\u5408:" + serviceNode.getIp() + " \u7684\u8282\u70b9\uff0c\u6309\u7167\u7b56\u7565\u8df3\u8fc7", null, 4, null);
                    return;
                }
                LoggingApi.logMessage$default(loggingApi, LogLevel.TRACE, "\u76ee\u6807\u8282\u70b9\u4e3a" + serviceNode.getIp() + "\uff0c\u4f46\u6211\u4eec\u627e\u5230\u7684\u662f:" + CollectionsKt.toMutableList((Collection)allInstances), null, 4, null);
                LoggingApi.logMessage$default(loggingApi, LogLevel.DEBUG, "\u867d\u7136\u6ca1\u6709\u627e\u5230\uff0c\u6839\u636e\u4e4b\u524d\u7684\u8bb0\u5f55\u5f3a\u884c\u6267\u884c", null, 4, null);
                NamingMaintainService namingMaintainService = NamingMaintainFactory.createMaintainService((Properties)this.properties);
                Intrinsics.checkNotNull((Object)serviceNode, (String)"null cannot be cast to non-null type io.github.caijiang.common.nacos.NacosService.NacosServiceNode");
                iterable = ((NacosServiceNode)serviceNode).getInstance();
                block.invoke((Object)iterable);
                namingMaintainService.updateInstance(this.serviceName, (Instance)iterable);
                return;
            }
        }
        Instance target = instance;
        LoggingApi.logMessage$default(loggingApi, LogLevel.DEBUG, "\u5728nacos\u627e\u5230\u76ee\u6807\u8282\u70b9\uff0c\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c", null, 4, null);
        NamingMaintainService namingMaintainService = NamingMaintainFactory.createMaintainService((Properties)this.properties);
        Instance instance2 = target;
        block.invoke((Object)instance2);
        namingMaintainService.updateInstance(this.serviceName, instance2);
    }

    static /* synthetic */ void changeInstance$default(NacosService nacosService, ServiceNode serviceNode, LoggingApi loggingApi, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        nacosService.changeInstance(serviceNode, loggingApi, bl, (Function1<? super Instance, Unit>)function1);
    }

    @Override
    public void suspendNode(@NotNull ServiceNode serviceNode, @NotNull LoggingApi loggingApi) {
        Intrinsics.checkNotNullParameter((Object)serviceNode, (String)"serviceNode");
        Intrinsics.checkNotNullParameter((Object)loggingApi, (String)"loggingApi");
        NacosService.changeInstance$default(this, serviceNode, loggingApi, false, suspendNode.1.INSTANCE, 4, null);
    }

    @Override
    public void resumedNode(@NotNull ServiceNode serviceNode, @NotNull LoggingApi loggingApi) {
        Intrinsics.checkNotNullParameter((Object)serviceNode, (String)"serviceNode");
        Intrinsics.checkNotNullParameter((Object)loggingApi, (String)"loggingApi");
        this.changeInstance(serviceNode, loggingApi, false, (Function1<? super Instance, Unit>)((Function1)resumedNode.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkWorkStatus(@NotNull ServiceNode node, @NotNull LoggingApi loggingApi) {
        boolean bl;
        Iterable<Map> iterable;
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)loggingApi, (String)"loggingApi");
        List list2 = NamingFactory.createNamingService((Properties)this.properties).getAllInstances(this.serviceName);
        LoggingApi.logMessage$default(loggingApi, LogLevel.TRACE, "checkWorkStatus:" + node.getIp() + ':' + node.getPort(), null, 4, null);
        LoggingApi loggingApi2 = loggingApi;
        LogLevel logLevel = LogLevel.TRACE;
        StringBuilder stringBuilder = new StringBuilder().append("fact list:");
        List list3 = list2;
        if (list3 != null) {
            Iterable<Map> iterable2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable3 = list3;
            StringBuilder stringBuilder2 = stringBuilder;
            LogLevel logLevel2 = logLevel;
            LoggingApi loggingApi3 = loggingApi2;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Instance instance = (Instance)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl2 = false;
                Pair[] pairArray = new Pair[3];
                pairArray[0] = TuplesKt.to((Object)"ip", (Object)it.getIp());
                pairArray[1] = TuplesKt.to((Object)"port", (Object)it.getPort());
                Intrinsics.checkNotNull((Object)it);
                pairArray[2] = TuplesKt.to((Object)"work", (Object)NacosServiceKt.access$work((Instance)it));
                iterable2.add(MapsKt.mapOf((Pair[])pairArray));
            }
            iterable2 = (List)destination$iv$iv;
            loggingApi2 = loggingApi3;
            logLevel = logLevel2;
            stringBuilder = stringBuilder2;
            iterable = iterable2;
        } else {
            iterable = null;
        }
        LoggingApi.logMessage$default(loggingApi2, logLevel, stringBuilder.append(iterable).toString(), null, 4, null);
        List list4 = list2;
        if (list4 != null) {
            boolean bl3;
            block9: {
                void $this$any$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list4;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Instance it = (Instance)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getIp(), (Object)node.getIp())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Instance it = (Instance)element$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!NacosServiceKt.access$work(it)) continue;
                        bl3 = true;
                        break block9;
                    }
                    bl3 = false;
                }
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ServiceNode> discoverNodes(@NotNull Service service) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        List list2 = NamingFactory.createNamingService((Properties)this.properties).getAllInstances(this.serviceName);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllInstances(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Instance instance = (Instance)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new NacosServiceNode((Instance)it, null, 0, false, 14, null));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/github/caijiang/common/nacos/NacosService$NacosServiceNode;", "Lio/github/caijiang/common/orchestration/ServiceNode;", "instance", "Lcom/alibaba/nacos/api/naming/pojo/Instance;", "ip", "", "port", "", "ingressLess", "", "(Lcom/alibaba/nacos/api/naming/pojo/Instance;Ljava/lang/String;IZ)V", "getIngressLess", "()Z", "getInstance", "()Lcom/alibaba/nacos/api/naming/pojo/Instance;", "getIp", "()Ljava/lang/String;", "getPort", "()I", "common-ext"})
    public static final class NacosServiceNode
    implements ServiceNode {
        @NotNull
        private final Instance instance;
        @NotNull
        private final String ip;
        private final int port;
        private final boolean ingressLess;

        public NacosServiceNode(@NotNull Instance instance, @NotNull String ip, int port, boolean ingressLess) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            this.instance = instance;
            this.ip = ip;
            this.port = port;
            this.ingressLess = ingressLess;
        }

        public /* synthetic */ NacosServiceNode(Instance instance, String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                String string2 = instance.getIp();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIp(...)");
                string = string2;
            }
            if ((n2 & 4) != 0) {
                n = instance.getPort();
            }
            if ((n2 & 8) != 0) {
                bl = !instance.isEnabled();
            }
            this(instance, string, n, bl);
        }

        @NotNull
        public final Instance getInstance() {
            return this.instance;
        }

        @Override
        @NotNull
        public String getIp() {
            return this.ip;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public boolean getIngressLess() {
            return this.ingressLess;
        }
    }
}

