/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.notify.config;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.notify.FeishuNotifyTool;
import io.github.caijiang.common.notify.Notifiable;
import io.github.caijiang.common.notify.NotifiableMessage;
import io.github.caijiang.common.notify.NotifyChannel;
import io.github.caijiang.common.notify.SendNoticeService;
import io.github.caijiang.common.notify.UrgentRole;
import io.github.caijiang.common.notify.config.NotifyConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/caijiang/common/notify/config/SendNoticeServiceImpl;", "Lio/github/caijiang/common/notify/SendNoticeService;", "notifyConfiguration", "Lio/github/caijiang/common/notify/config/NotifyConfiguration;", "(Lio/github/caijiang/common/notify/config/NotifyConfiguration;)V", "pool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "beforeClose", "", "send", "notify", "Lio/github/caijiang/common/notify/Notifiable;", "sendMessage", "targetConfig", "Lio/github/caijiang/common/notify/config/NotifyConfiguration$TargetConfig;", "message", "Lio/github/caijiang/common/notify/NotifiableMessage;", "sendThrowable", "throwable", "", "sendThrowableCount", "count", "", "common-ext"})
@SourceDebugExtension(value={"SMAP\nSendNoticeServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendNoticeServiceImpl.kt\nio/github/caijiang/common/notify/config/SendNoticeServiceImpl\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n16#2:69\n16#2:75\n3792#3:70\n4307#3,2:71\n1855#4,2:73\n*S KotlinDebug\n*F\n+ 1 SendNoticeServiceImpl.kt\nio/github/caijiang/common/notify/config/SendNoticeServiceImpl\n*L\n22#1:69\n51#1:75\n44#1:70\n44#1:71,2\n46#1:73,2\n*E\n"})
public class SendNoticeServiceImpl
implements SendNoticeService {
    @NotNull
    private final NotifyConfiguration notifyConfiguration;
    private final ExecutorService pool;

    public SendNoticeServiceImpl(@NotNull NotifyConfiguration notifyConfiguration) {
        Intrinsics.checkNotNullParameter((Object)notifyConfiguration, (String)"notifyConfiguration");
        this.notifyConfiguration = notifyConfiguration;
        this.pool = Executors.newFixedThreadPool(this.notifyConfiguration.getThreadSize());
    }

    @PreDestroy
    public final void beforeClose() {
        this.pool.shutdown();
    }

    private final void sendMessage(NotifyConfiguration.TargetConfig targetConfig, NotifiableMessage message) {
        Object object;
        Slf4j.Companion companion = Slf4j.Companion;
        SendNoticeServiceImpl $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(SendNoticeServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u51c6\u5907\u53d1\u9001\u6d88\u606f:{} \u901a\u8fc7:{}", (Object)message.getTitle(), (Object)targetConfig);
        NotifyChannel notifyChannel = targetConfig.getChannel();
        if ((notifyChannel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[notifyChannel.ordinal()]) != 1) {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u901a\u77e5\u901a\u9053:" + (Object)((Object)targetConfig.getChannel()));
        }
        Properties properties = targetConfig.getProperties();
        Intrinsics.checkNotNull((Object)properties);
        FeishuNotifyTool.sendMessage(String.valueOf(properties.get("url")), message, (object = targetConfig.getProperties()) != null && (object = ((Properties)object).get("key")) != null ? object.toString() : null);
    }

    @Override
    public void send(@NotNull Notifiable notify) {
        Intrinsics.checkNotNullParameter((Object)notify, (String)"notify");
        this.pool.submit(() -> SendNoticeServiceImpl.send$lambda$3(notify, this));
    }

    @Override
    public void sendThrowable(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.sendThrowableCount(throwable, 5);
    }

    private final void sendThrowableCount(Throwable throwable, int count) {
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            return;
        }
        Throwable tx = throwable2;
        if (tx instanceof Notifiable) {
            this.send((Notifiable)((Object)tx));
        } else {
            if (count <= 0) {
                return;
            }
            this.sendThrowableCount(tx.getCause(), count - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void send$lambda$3(Notifiable $notify, SendNoticeServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)$notify, (String)"$notify");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            UrgentRole urgentRole = $notify.getUrgentRole();
            if (urgentRole != null) {
                UrgentRole role = urgentRole;
                boolean bl = false;
                Set<NotifyChannel> excludes = $notify.excludeChannels();
                NotifyConfiguration.TargetConfig[] targetConfigArray = this$0.notifyConfiguration.getRoles().get((Object)role);
                if (targetConfigArray != null) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Object $this$filter$iv = targetConfigArray;
                    boolean $i$f$filter = false;
                    NotifyConfiguration.TargetConfig[] targetConfigArray2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl2 = false;
                        if (!(excludes == null || !CollectionsKt.contains((Iterable)excludes, (Object)((Object)it.getChannel())))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        NotifyConfiguration.TargetConfig it = (NotifyConfiguration.TargetConfig)element$iv;
                        boolean bl3 = false;
                        this$0.sendMessage(it, $notify.getNotifiableMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            Slf4j.Companion companion = Slf4j.Companion;
            SendNoticeServiceImpl $this$log$iv = this$0;
            boolean $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(SendNoticeServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.error("\u53d1\u9001\u901a\u77e5\u65f6", (Throwable)ex);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotifyChannel.values().length];
            try {
                nArray[NotifyChannel.Feishu.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

