/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.job.scheduler;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonDeletingOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.job.scheduler.Scheduler;
import io.github.caijiang.common.job.worker.PersistentJob;
import io.github.caijiang.common.job.worker.SerializableJob;
import io.github.caijiang.common.job.worker.TemporaryJob;
import io.github.caijiang.common.k8s.KubernetesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0016H\u0002J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\u0018\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/github/caijiang/common/job/scheduler/KubernetesJobScheduler;", "Lio/github/caijiang/common/job/scheduler/Scheduler;", "client", "Lio/fabric8/kubernetes/client/KubernetesClient;", "(Lio/fabric8/kubernetes/client/KubernetesClient;)V", "buildEnvsFor", "", "container", "Lio/fabric8/kubernetes/api/model/Container;", "job", "Lio/github/caijiang/common/job/worker/SerializableJob;", "cleanPersistentJob", "env", "", "hostname", "jobName", "createEnvList", "", "Lio/fabric8/kubernetes/api/model/EnvVar;", "createPodTemplateSpec", "Lio/fabric8/kubernetes/api/model/PodTemplateSpec;", "jobLabels", "", "removeAllProbe", "submitPersistentJob", "cron", "Lio/github/caijiang/common/job/worker/PersistentJob;", "timezone", "Ljava/util/TimeZone;", "submitTemporaryJob", "Lio/github/caijiang/common/job/worker/TemporaryJob;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nKubernetesJobScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesJobScheduler.kt\nio/github/caijiang/common/job/scheduler/KubernetesJobScheduler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,186:1\n1855#2,2:187\n1855#2,2:189\n766#2:191\n857#2,2:192\n1238#2,4:196\n468#3:194\n414#3:195\n125#4:200\n152#4,3:201\n16#5:204\n16#5:205\n16#5:206\n*S KotlinDebug\n*F\n+ 1 KubernetesJobScheduler.kt\nio/github/caijiang/common/job/scheduler/KubernetesJobScheduler\n*L\n39#1:187,2\n45#1:189,2\n71#1:191\n71#1:192,2\n78#1:196,4\n78#1:194\n78#1:195\n80#1:200\n80#1:201,3\n105#1:204\n129#1:205\n164#1:206\n*E\n"})
public final class KubernetesJobScheduler
implements Scheduler {
    @NotNull
    private final KubernetesClient client;

    public KubernetesJobScheduler(@NotNull KubernetesClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    public /* synthetic */ KubernetesJobScheduler(KubernetesClient kubernetesClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            KubernetesClient kubernetesClient2 = new KubernetesClientBuilder().build();
            Intrinsics.checkNotNullExpressionValue((Object)kubernetesClient2, (String)"build(...)");
            kubernetesClient = kubernetesClient2;
        }
        this(kubernetesClient);
    }

    private final PodTemplateSpec createPodTemplateSpec(String env, String hostname, SerializableJob job, Map<String, String> jobLabels) {
        Container it;
        PodSpec origins = ((Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(env)).withName(hostname)).get()).getSpec();
        PodSpec newSpec = new PodSpecBuilder(origins).build();
        List list2 = newSpec.getContainers();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContainers(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Container)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.buildEnvsFor(it, job);
        }
        newSpec.setRestartPolicy("Never");
        List list3 = newSpec.getContainers();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getContainers(...)");
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Container)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.removeAllProbe(it);
        }
        newSpec.setNodeName(null);
        PodTemplateSpec podTemplateSpec = ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(newSpec)).withNewMetadata().withLabels(jobLabels)).endMetadata()).build();
        Intrinsics.checkNotNullExpressionValue((Object)podTemplateSpec, (String)"build(...)");
        return podTemplateSpec;
    }

    private final void removeAllProbe(Container container) {
        container.setReadinessProbe(null);
        container.setStartupProbe(null);
        container.setLivenessProbe(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildEnvsFor(Container container, SerializableJob job) {
        List list2 = container.getEnv();
        boolean bl = list2 != null ? ((Collection)list2).isEmpty() : false;
        if (bl) {
            container.setEnv(this.createEnvList(job));
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list3 = container.getEnv();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEnv(...)");
            Iterable iterable = list3;
            Container container2 = container;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                String string;
                EnvVar it = (EnvVar)element$iv$iv;
                boolean bl3 = false;
                String string2 = string = it.getName();
                if (string2 != null) {
                    Intrinsics.checkNotNull((Object)string2);
                    bl2 = StringsKt.startsWith$default((String)string, (String)"CE_JOB_", (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                if (!(!bl2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            container2.setEnv(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.createEnvList(job)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<EnvVar> createEnvList(SerializableJob job) {
        void $this$mapTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Map<String, String> $this$mapKeys$iv = job.getParameters();
        boolean $i$f$mapKeys = false;
        Map<String, String> map = $this$mapKeys$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = "CE_JOB_ARG_" + (String)it.getKey();
            Map map2 = object;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map2.put(string, entry);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapKeysTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            Map.Entry entry = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)it.getKey())).withValue((String)it.getValue())).build());
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("CE_JOB_TYPE")).withValue(job.getType())).build()));
    }

    private final Map<String, String> jobLabels(String env, String hostname, SerializableJob job) {
        Object object;
        try {
            Pod a = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(env)).withName(hostname)).get();
            Intrinsics.checkNotNull((Object)a);
            HasMetadata root = KubernetesUtils.INSTANCE.topOwner((HasMetadata)a, this.client);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"job.common-ext.caijiang.github.io/deployment-kind", (Object)root.getKind()), TuplesKt.to((Object)"job.common-ext.caijiang.github.io/deployment-id", (Object)root.getMetadata().getName())};
            object = MapsKt.mapOf((Pair[])pairArray);
        }
        catch (Exception e) {
            Slf4j.Companion companion = Slf4j.Companion;
            KubernetesJobScheduler $this$log$iv = this;
            boolean $i$f$getLog = false;
            Logger logger = LoggerFactory.getLogger(KubernetesJobScheduler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.error("\u83b7\u53d6\u90e8\u7f72\u4fe1\u606f\u65f6", (Throwable)e);
            object = MapsKt.emptyMap();
        }
        Pair[] deploymentLabels = object;
        object = new Pair[]{TuplesKt.to((Object)"job.common-ext.caijiang.github.io/from-env", (Object)env), TuplesKt.to((Object)"job.common-ext.caijiang.github.io/from-hostname", (Object)hostname), TuplesKt.to((Object)"job.common-ext.caijiang.github.io/type", (Object)job.getType())};
        return MapsKt.plus((Map)MapsKt.mapOf((Pair[])object), (Map)deploymentLabels);
    }

    @Override
    public void submitTemporaryJob(@NotNull String env, @NotNull String hostname, @NotNull TemporaryJob job) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Map<String, String> jobLabels = this.jobLabels(env, hostname, job);
        Job k8sJob = ((JobBuilder)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withNamespace(env)).withGenerateName("ce-temp-job-" + job.getType() + '-')).withLabels(jobLabels)).endMetadata()).withNewSpec().withTtlSecondsAfterFinished(Integer.valueOf((int)Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS))))).withTemplate(this.createPodTemplateSpec(env, hostname, job, jobLabels))).endSpec()).build();
        Slf4j.Companion companion = Slf4j.Companion;
        KubernetesJobScheduler $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(KubernetesJobScheduler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u51c6\u5907\u521b\u5efa k8s-job:{}", (Object)k8sJob);
        ((ScalableResource)this.client.batch().v1().jobs().resource((Object)k8sJob)).create();
    }

    @Override
    public void submitPersistentJob(@NotNull String env, @NotNull String hostname, @NotNull String cron, @NotNull PersistentJob job, @NotNull TimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Map<String, String> jobLabels = this.jobLabels(env, hostname, job);
        CronJob k8sJob = ((CronJobBuilder)((CronJobFluent.SpecNested)((CronJobSpecFluent.JobTemplateNested)((JobTemplateSpecFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobFluent.SpecNested)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withNamespace(env)).withName("ce-job-" + job.getName())).withLabels(jobLabels)).endMetadata()).withNewSpec().withConcurrencyPolicy("Forbid")).withSchedule(cron)).withTimeZone(timezone.toZoneId().getId())).withNewJobTemplate().withNewSpec().withTemplate(this.createPodTemplateSpec(env, hostname, job, jobLabels))).endSpec()).endJobTemplate()).endSpec()).build();
        Slf4j.Companion companion = Slf4j.Companion;
        KubernetesJobScheduler $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(KubernetesJobScheduler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u51c6\u5907\u521b\u5efa k8s-cron-job:{}", (Object)k8sJob);
        ((Resource)this.client.batch().v1().cronjobs().resource((Object)k8sJob)).createOr(KubernetesJobScheduler::submitPersistentJob$lambda$5);
    }

    @Override
    public void cleanPersistentJob(@NotNull String env, @NotNull String hostname, @NotNull String jobName) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        ((Resource)this.client.batch().v1().cronjobs().resource((Object)((CronJobBuilder)((CronJobFluent.MetadataNested)((CronJobFluent.MetadataNested)new CronJobBuilder().withNewMetadata().withNamespace(env)).withName("ce-job-" + jobName)).endMetadata()).build())).delete();
    }

    private static final CronJob submitPersistentJob$lambda$5(NonDeletingOperation it) {
        return (CronJob)it.update();
    }

    public KubernetesJobScheduler() {
        this(null, 1, null);
    }
}

