/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.job.worker.bean;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.job.worker.JobTypeRunner;
import io.github.caijiang.common.job.worker.PersistentJob;
import io.github.caijiang.common.job.worker.ScheduleJobService;
import io.github.caijiang.common.job.worker.TemporaryJob;
import io.github.caijiang.common.job.worker.bean.TaskSchedulerScheduleJobService;
import io.github.caijiang.common.job.worker.bean.WorkerRunner;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J(\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0016H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/caijiang/common/job/worker/bean/TaskSchedulerScheduleJobService;", "Lio/github/caijiang/common/job/worker/ScheduleJobService;", "runner", "Lio/github/caijiang/common/job/worker/JobTypeRunner;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "(Lio/github/caijiang/common/job/worker/JobTypeRunner;Lorg/springframework/scheduling/TaskScheduler;)V", "futures", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/ScheduledFuture;", "cleanPersistentJob", "", "jobName", "submitPersistentJob", "cron", "job", "Lio/github/caijiang/common/job/worker/PersistentJob;", "timezone", "Ljava/util/TimeZone;", "springCronSeconds", "submitTemporaryJob", "Lio/github/caijiang/common/job/worker/TemporaryJob;", "common-ext"})
@SourceDebugExtension(value={"SMAP\nTaskSchedulerScheduleJobService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskSchedulerScheduleJobService.kt\nio/github/caijiang/common/job/worker/bean/TaskSchedulerScheduleJobService\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n*L\n1#1,61:1\n16#2:62\n16#2:63\n16#2:64\n*S KotlinDebug\n*F\n+ 1 TaskSchedulerScheduleJobService.kt\nio/github/caijiang/common/job/worker/bean/TaskSchedulerScheduleJobService\n*L\n30#1:62\n44#1:63\n33#1:64\n*E\n"})
public final class TaskSchedulerScheduleJobService
implements ScheduleJobService {
    @NotNull
    private final JobTypeRunner runner;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final ConcurrentHashMap<String, ScheduledFuture<?>> futures;

    public TaskSchedulerScheduleJobService(@NotNull JobTypeRunner runner, @NotNull TaskScheduler taskScheduler) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        this.runner = runner;
        this.taskScheduler = taskScheduler;
        WorkerRunner.INSTANCE.executeCurrentJob(this.runner);
        this.futures = new ConcurrentHashMap();
    }

    public /* synthetic */ TaskSchedulerScheduleJobService(JobTypeRunner jobTypeRunner, TaskScheduler taskScheduler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ThreadPoolTaskScheduler threadPoolTaskScheduler;
            ThreadPoolTaskScheduler $this$_init__u24lambda_u240 = threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
            boolean bl = false;
            $this$_init__u24lambda_u240.initialize();
            taskScheduler = (TaskScheduler)threadPoolTaskScheduler;
        }
        this(jobTypeRunner, taskScheduler);
    }

    @Override
    public void submitTemporaryJob(@NotNull TemporaryJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        WorkerRunner.INSTANCE.valid(job);
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u5411 TaskScheduler \u53d1\u8d77 temporary \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{}", (Object)job.getType());
        this.taskScheduler.schedule(() -> TaskSchedulerScheduleJobService.submitTemporaryJob$lambda$1(this, job), new Date());
    }

    @Override
    public void submitPersistentJob(@NotNull String cron, @NotNull PersistentJob job, @NotNull TimeZone timezone, @NotNull String springCronSeconds) {
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Intrinsics.checkNotNullParameter((Object)springCronSeconds, (String)"springCronSeconds");
        WorkerRunner.INSTANCE.valid(job);
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u5411 TaskScheduler \u53d1\u8d77 persistent \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{},\u540d\u79f0:{}", (Object)job.getType(), (Object)job.getName());
        this.futures.compute(job.getName(), (arg_0, arg_1) -> TaskSchedulerScheduleJobService.submitPersistentJob$lambda$2((Function2)new Function2<String, ScheduledFuture<?>, ScheduledFuture<?>>(this, springCronSeconds, cron, job){
            final /* synthetic */ TaskSchedulerScheduleJobService this$0;
            final /* synthetic */ String $springCronSeconds;
            final /* synthetic */ String $cron;
            final /* synthetic */ PersistentJob $job;
            {
                this.this$0 = $receiver;
                this.$springCronSeconds = $springCronSeconds;
                this.$cron = $cron;
                this.$job = $job;
                super(2);
            }

            @Nullable
            public final ScheduledFuture<?> invoke(@NotNull String string, @Nullable ScheduledFuture<?> v) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    ScheduledFuture<?> scheduledFuture = v;
                    if (scheduledFuture == null) break block0;
                    scheduledFuture.cancel(true);
                }
                return TaskSchedulerScheduleJobService.access$getTaskScheduler$p(this.this$0).schedule(() -> submitPersistentJob.1.invoke$lambda$0(this.this$0, this.$job), (Trigger)new CronTrigger(this.$springCronSeconds + ' ' + this.$cron, TimeZone.getDefault()));
            }

            private static final void invoke$lambda$0(TaskSchedulerScheduleJobService this$0, PersistentJob $job) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
                Slf4j.Companion companion = Slf4j.Companion;
                TaskSchedulerScheduleJobService $this$log$iv = this$0;
                boolean $i$f$getLog = false;
                Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.debug("TaskScheduler \u6267\u884c persistent \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{},\u540d\u79f0:{}", (Object)$job.getType(), (Object)$job.getName());
                TaskSchedulerScheduleJobService.access$getRunner$p(this$0).run($job);
            }
        }, arg_0, arg_1));
    }

    @Override
    public void cleanPersistentJob(@NotNull String jobName) {
        block0: {
            ScheduledFuture<?> one;
            Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
            WorkerRunner.INSTANCE.validJobName(jobName);
            ScheduledFuture<?> scheduledFuture = one = this.futures.remove(jobName);
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    private static final void submitTemporaryJob$lambda$1(TaskSchedulerScheduleJobService this$0, TemporaryJob $job) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Slf4j.Companion companion = Slf4j.Companion;
        TaskSchedulerScheduleJobService $this$log$iv = this$0;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(TaskSchedulerScheduleJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("TaskScheduler \u6267\u884c temporary \u8c03\u5ea6\u8bf7\u6c42:\u7c7b\u578b:{}", (Object)$job.getType());
        this$0.runner.run($job);
    }

    private static final ScheduledFuture submitPersistentJob$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScheduledFuture)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ TaskScheduler access$getTaskScheduler$p(TaskSchedulerScheduleJobService $this) {
        return $this.taskScheduler;
    }

    public static final /* synthetic */ JobTypeRunner access$getRunner$p(TaskSchedulerScheduleJobService $this) {
        return $this.runner;
    }
}

