/*
 * Decompiled with CFR 0.152.
 */
package io.github.caijiang.common.job.worker.bean;

import io.github.caijiang.common.Slf4j;
import io.github.caijiang.common.job.worker.JobTypeRunner;
import io.github.caijiang.common.job.worker.PersistentJob;
import io.github.caijiang.common.job.worker.SerializableJob;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/caijiang/common/job/worker/bean/WorkerRunner;", "", "()V", "envName", "Lkotlin/text/Regex;", "rfc1123", "executeCurrentJob", "", "runner", "Lio/github/caijiang/common/job/worker/JobTypeRunner;", "valid", "job", "Lio/github/caijiang/common/job/worker/SerializableJob;", "validJobName", "jobName", "", "common-ext"})
@SourceDebugExtension(value={"SMAP\nWorkerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerRunner.kt\nio/github/caijiang/common/job/worker/bean/WorkerRunner\n+ 2 Slf4j.kt\nio/github/caijiang/common/Slf4j$Companion\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n16#2:89\n16#2:110\n16#2:111\n16#2:112\n478#3,7:90\n468#3:97\n414#3:98\n494#3,7:103\n1238#4,4:99\n1747#4,3:113\n*S KotlinDebug\n*F\n+ 1 WorkerRunner.kt\nio/github/caijiang/common/job/worker/bean/WorkerRunner\n*L\n16#1:89\n24#1:110\n31#1:111\n42#1:112\n18#1:90,7\n20#1:97\n20#1:98\n22#1:103,7\n20#1:99,4\n68#1:113,3\n*E\n"})
public final class WorkerRunner {
    @NotNull
    public static final WorkerRunner INSTANCE = new WorkerRunner();
    @NotNull
    private static final Regex rfc1123 = new Regex("^[a-z0-9]([-a-z0-9]*[a-z0-9])?$");
    @NotNull
    private static final Regex envName = new Regex("^[A-Za-z_][A-Za-z0-9_]*$");

    private WorkerRunner() {
    }

    /*
     * WARNING - void declaration
     */
    public final void executeCurrentJob(@NotNull JobTypeRunner runner) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        String type = System.getenv("CE_JOB_TYPE");
        Slf4j.Companion companion = Slf4j.Companion;
        WorkerRunner $this$log$iv = this;
        boolean $i$f$getLog = false;
        Logger logger = LoggerFactory.getLogger(WorkerRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("\u68c0\u67e5\u5f53\u524d\u662f\u5426\u4e3a\u4efb\u52a1\u6a21\u5f0f:{}", (Object)type);
        String string = type;
        boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
        if (bl) {
            Slf4j.Companion $this$filterValues$iv;
            void $this$mapKeysTo$iv$iv;
            Map $this$mapKeys$iv;
            String it;
            Map map = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
            Map $this$filterKeys$iv = map;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : $this$filterKeys$iv.entrySet()) {
                boolean bl2;
                it = entry.getKey();
                boolean bl3 = false;
                String string2 = it;
                if (string2 != null) {
                    Intrinsics.checkNotNull((Object)string2);
                    bl2 = StringsKt.startsWith$default((String)it, (String)"CE_JOB_ARG_", (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean bl3 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it2;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl4 = false;
                Object k = it2.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string3 = StringsKt.removePrefix((String)((String)k), (CharSequence)"CE_JOB_ARG_");
                Map map3 = map2;
                boolean bl5 = false;
                entry = it$iv$iv.getValue();
                map3.put(string3, entry);
            }
            $this$mapKeys$iv = destination$iv$iv;
            boolean $i$f$filterValues = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
                it = (String)entry.getValue();
                boolean bl6 = false;
                if (!(it != null)) continue;
                result$iv.put((String)entry.getKey(), (String)entry.getValue());
            }
            Map ps = result$iv;
            try {
                boolean this_$iv;
                $this$filterValues$iv = Slf4j.Companion;
                WorkerRunner $this$log$iv2 = this;
                boolean $i$f$getLog2 = false;
                Logger logger2 = LoggerFactory.getLogger(WorkerRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
                logger2.info("\u51c6\u5907\u6267\u884c\u4efb\u52a1:{},\u53c2\u6570:{}", (Object)type, (Object)ps);
                runner.run(new SerializableJob(type, ps){
                    final /* synthetic */ String $type;
                    final /* synthetic */ Map<String, String> $ps;
                    {
                        this.$type = $type;
                        this.$ps = $ps;
                    }

                    @NotNull
                    public String getType() {
                        return this.$type;
                    }

                    @NotNull
                    public Map<String, String> getParameters() {
                        return this.$ps;
                    }
                });
                Slf4j.Companion this_$iv2 = Slf4j.Companion;
                WorkerRunner $this$log$iv3 = this;
                boolean $i$f$getLog3 = false;
                Logger logger3 = LoggerFactory.getLogger(WorkerRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(...)");
                logger3.info("\u4efb\u52a1:{},\u53c2\u6570:{}\u5b8c\u6210,\u5373\u5c06\u4f7f\u7528\u9000\u51fa\u4ee3\u7801 0 \u7ed3\u675f \u8fdb\u7a0b", (Object)type, (Object)ps);
                try {
                    this_$iv = runner.quitApplication();
                }
                catch (Exception e2) {
                    this_$iv = false;
                }
                if (this_$iv) {
                    System.exit(0);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                Runtime.getRuntime().halt(0);
            }
            catch (Throwable e) {
                boolean bl7;
                Slf4j.Companion e2 = Slf4j.Companion;
                WorkerRunner $this$log$iv3 = this;
                boolean $i$f$getLog3 = false;
                Logger logger4 = LoggerFactory.getLogger(WorkerRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getLogger(...)");
                Object[] objectArray = new Object[]{type, ps, e};
                logger4.error("\u6267\u884c\u4efb\u52a1:{},\u53c2\u6570:{}\u62a5\u9519,\u5373\u5c06\u4f7f\u7528\u9000\u51fa\u4ee3\u7801 1 \u7ed3\u675f\u8fdb\u7a0b", objectArray);
                try {
                    bl7 = runner.quitApplication();
                }
                catch (Exception e3) {
                    bl7 = false;
                }
                if (bl7) {
                    System.exit(1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                Runtime.getRuntime().halt(1);
            }
        }
    }

    public final void valid(@NotNull SerializableJob job) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            if (!rfc1123.matches((CharSequence)job.getType())) {
                throw new IllegalArgumentException("job.type:" + job.getType() + " is not valid");
            }
            if (job.getType().length() > 43) {
                throw new IllegalArgumentException("job.type:" + job.getType() + " too large");
            }
            if (((CharSequence)job.getType()).length() == 0) {
                throw new IllegalArgumentException("job.type:" + job.getType() + " can not be empty");
            }
            Iterable $this$any$iv = job.getParameters().keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!envName.matches((CharSequence)it))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("job.parameters:" + job.getParameters() + " is not valid");
        }
        if (job instanceof PersistentJob) {
            this.validJobName(((PersistentJob)job).getName());
        }
    }

    public final void validJobName(@NotNull String jobName) {
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        if (!rfc1123.matches((CharSequence)jobName)) {
            throw new IllegalArgumentException("job.name:" + jobName + " is not valid");
        }
        if (jobName.length() > 53) {
            throw new IllegalArgumentException("job.name:" + jobName + " too large");
        }
        if (((CharSequence)jobName).length() == 0) {
            throw new IllegalArgumentException("job.name:" + jobName + " can not be empty");
        }
    }
}

