/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.japierrors;

import io.github.cdimascio.japierrors.ApiErrorCreator;
import io.github.cdimascio.japierrors.HttpStatus;
import io.github.cdimascio.japierrors.IApiErrorCreator;

public abstract class ApiError
extends Exception {
    private static IApiErrorCreator error = ApiErrorCreator.BASIC;

    public static <T extends ApiError> void creator(IApiErrorCreator<T> creator) {
        error = creator;
    }

    private static <T extends ApiError> IApiErrorCreator<T> getCreator() {
        return error;
    }

    public static <T extends ApiError> T badRequest(Throwable t) {
        return error.create(HttpStatus.BAD_REQUEST, t);
    }

    public static <T extends ApiError> T badRequest(String message) {
        return error.create(HttpStatus.BAD_REQUEST, message);
    }

    public static <T extends ApiError> T badRequest() {
        return error.create(HttpStatus.BAD_REQUEST, "bad request");
    }

    public static <T extends ApiError> T conflict(Throwable t) {
        return error.create(HttpStatus.CONFLICT, t);
    }

    public static <T extends ApiError> T conflict(String message) {
        return error.create(HttpStatus.CONFLICT, message);
    }

    public static <T extends ApiError> T conflict() {
        return error.create(HttpStatus.CONFLICT, "conflict");
    }

    public static <T extends ApiError> T forbidden(Throwable t) {
        return error.create(HttpStatus.FORBIDDEN, t);
    }

    public static <T extends ApiError> T forbidden(String message) {
        return error.create(HttpStatus.FORBIDDEN, message);
    }

    public static <T extends ApiError> T forbidden() {
        return error.create(HttpStatus.FORBIDDEN, "forbidden");
    }

    public static <T extends ApiError> T gatewayTimeout(Throwable t) {
        return error.create(HttpStatus.GATEWAY_TIMEOUT, t);
    }

    public static <T extends ApiError> T gatewayTimeout(String message) {
        return error.create(HttpStatus.GATEWAY_TIMEOUT, message);
    }

    public static <T extends ApiError> T gatewayTimeout() {
        return error.create(HttpStatus.GATEWAY_TIMEOUT, "gateway timeout");
    }

    public static <T extends ApiError> T gone(Throwable t) {
        return error.create(HttpStatus.GONE, t);
    }

    public static <T extends ApiError> T gone(String message) {
        return error.create(HttpStatus.GONE, message);
    }

    public static <T extends ApiError> T gone() {
        return error.create(HttpStatus.GONE, "gone");
    }

    public static <T extends ApiError> T internalServerError(Throwable t) {
        return error.create(HttpStatus.INTERNAL_SERVER_ERROR, t);
    }

    public static <T extends ApiError> T internalServerError(String message) {
        return error.create(HttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    public static <T extends ApiError> T internalServerError() {
        return error.create(HttpStatus.INTERNAL_SERVER_ERROR, "internal server error");
    }

    public static <T extends ApiError> T notAcceptable(Throwable t) {
        return error.create(HttpStatus.NOT_ACCEPTABLE, t);
    }

    public static <T extends ApiError> T notAcceptable(String message) {
        return error.create(HttpStatus.NOT_ACCEPTABLE, message);
    }

    public static <T extends ApiError> T notAcceptable() {
        return error.create(HttpStatus.NOT_ACCEPTABLE, "not found");
    }

    public static <T extends ApiError> T notFound(Throwable t) {
        return error.create(HttpStatus.NOT_FOUND, t);
    }

    public static <T extends ApiError> T notFound(String message) {
        return error.create(HttpStatus.NOT_FOUND, message);
    }

    public static <T extends ApiError> T notFound() {
        return error.create(HttpStatus.NOT_FOUND, "not found");
    }

    public static <T extends ApiError> T notImplemented(Throwable t) {
        return error.create(HttpStatus.NOT_IMPLEMENTED, t);
    }

    public static <T extends ApiError> T notImplemented(String message) {
        return error.create(HttpStatus.NOT_IMPLEMENTED, message);
    }

    public static <T extends ApiError> T notImplemented() {
        return error.create(HttpStatus.NOT_IMPLEMENTED, "not implemented");
    }

    public static <T extends ApiError> T preconditionFailed(Throwable t) {
        return error.create(HttpStatus.PRECONDITION_FAILED, t);
    }

    public static <T extends ApiError> T preconditionFailed(String message) {
        return error.create(HttpStatus.PRECONDITION_FAILED, message);
    }

    public static <T extends ApiError> T preconditionFailed() {
        return error.create(HttpStatus.PRECONDITION_FAILED, "precondition failed");
    }

    public static <T extends ApiError> T preconditionRequired(Throwable t) {
        return error.create(HttpStatus.PRECONDITION_REQUIRED, t);
    }

    public static <T extends ApiError> T preconditionRequired(String message) {
        return error.create(HttpStatus.PRECONDITION_REQUIRED, message);
    }

    public static <T extends ApiError> T preconditionRequired() {
        return error.create(HttpStatus.PRECONDITION_REQUIRED, "precondition required");
    }

    public static <T extends ApiError> T proxyAuthenticationRequired(Throwable t) {
        return error.create(HttpStatus.PROXY_AUTHENTICATION_REQUIRED, t);
    }

    public static <T extends ApiError> T proxyAuthenticationRequired(String message) {
        return error.create(HttpStatus.PROXY_AUTHENTICATION_REQUIRED, message);
    }

    public static <T extends ApiError> T proxyAuthenticationRequired() {
        return error.create(HttpStatus.PROXY_AUTHENTICATION_REQUIRED, "proxy authentication required");
    }

    public static <T extends ApiError> T requestEntityTooLarge(Throwable t) {
        return error.create(HttpStatus.REQUEST_ENTITY_TOO_LARGE, t);
    }

    public static <T extends ApiError> T requestEntityTooLarge(String message) {
        return error.create(HttpStatus.REQUEST_ENTITY_TOO_LARGE, message);
    }

    public static <T extends ApiError> T requestEntityTooLarge() {
        return error.create(HttpStatus.NOT_IMPLEMENTED, "not implemented");
    }

    public static <T extends ApiError> T serviceUnavailable(Throwable t) {
        return error.create(HttpStatus.SERVICE_UNAVAILABLE, t);
    }

    public static <T extends ApiError> T serviceUnavailable(String message) {
        return error.create(HttpStatus.SERVICE_UNAVAILABLE, message);
    }

    public static <T extends ApiError> T serviceUnavailable() {
        return error.create(HttpStatus.SERVICE_UNAVAILABLE, "service unavailable");
    }

    public static <T extends ApiError> T unauthorized(Throwable t) {
        return error.create(HttpStatus.UNAUTHORIZED, t);
    }

    public static <T extends ApiError> T unauthorized(String message) {
        return error.create(HttpStatus.UNAUTHORIZED, message);
    }

    public static <T extends ApiError> T unauthorized() {
        return error.create(HttpStatus.UNAUTHORIZED, "unauthorized");
    }

    public static <T extends ApiError> T unavailableForLegalReasons(Throwable t) {
        return error.create(HttpStatus.UNAVAILABLE_FOR_LEGAL_REASONS, t);
    }

    public static <T extends ApiError> T unavailableForLegalReasons(String message) {
        return error.create(HttpStatus.UNAVAILABLE_FOR_LEGAL_REASONS, message);
    }

    public static <T extends ApiError> T unavailableForLegalReasons() {
        return error.create(HttpStatus.UNAVAILABLE_FOR_LEGAL_REASONS, "unavailable for legal reasons");
    }

    public static <T extends ApiError> T unsupportedMediaType(Throwable t) {
        return error.create(HttpStatus.UNSUPPORTED_MEDIA_TYPE, t);
    }

    public static <T extends ApiError> T unsupportedMediaType(String message) {
        return error.create(HttpStatus.UNSUPPORTED_MEDIA_TYPE, message);
    }

    public static <T extends ApiError> T unsupportedMediaType() {
        return error.create(HttpStatus.UNSUPPORTED_MEDIA_TYPE, "unsupported media type");
    }

    public static <T extends ApiError> T upgradeRequired(Throwable t) {
        return error.create(HttpStatus.UPGRADE_REQUIRED, t);
    }

    public static <T extends ApiError> T upgradeRequired(String message) {
        return error.create(HttpStatus.UPGRADE_REQUIRED, message);
    }

    public static <T extends ApiError> T upgradeRequired() {
        return error.create(HttpStatus.UPGRADE_REQUIRED, "upgrade required");
    }
}

