/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago;

import com.google.gson.Gson;
import dev.koifysh.archipelago.ClientStatus;
import dev.koifysh.archipelago.EventManager;
import dev.koifysh.archipelago.ItemManager;
import dev.koifysh.archipelago.LocationManager;
import dev.koifysh.archipelago.WebSocket;
import dev.koifysh.archipelago.network.client.BouncePacket;
import dev.koifysh.archipelago.network.client.CreateAsHint;
import dev.koifysh.archipelago.network.client.GetPacket;
import dev.koifysh.archipelago.network.client.SetNotifyPacket;
import dev.koifysh.archipelago.network.client.SetPacket;
import dev.koifysh.archipelago.network.client.StatusUpdatePacket;
import dev.koifysh.archipelago.network.client.SyncPacket;
import dev.koifysh.archipelago.network.server.ConnectUpdatePacket;
import dev.koifysh.archipelago.network.server.RoomInfoPacket;
import dev.koifysh.archipelago.parts.DataPackage;
import dev.koifysh.archipelago.parts.NetworkSlot;
import dev.koifysh.archipelago.parts.Version;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.apache.hc.core5.net.URIBuilder;

public abstract class Client {
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static final Path windowsDataPackageCache;
    private static final Path otherDataPackageCache;
    private static Path dataPackageLocation;
    protected Map<String, String> versions;
    protected ArrayList<String> games;
    private static final Gson gson;
    private int hintPoints;
    private WebSocket webSocket;
    private String password;
    private final String UUID;
    private RoomInfoPacket roomInfo;
    private DataPackage dataPackage;
    public static Client client;
    private final LocationManager locationManager;
    private final ItemManager itemManager;
    private final EventManager eventManager;
    public static final Version protocolVersion;
    private int team;
    private int slot;
    private HashMap<Integer, NetworkSlot> slotInfo;
    private String name = "Name not set";
    private String game = "Game not set";
    private String alias;
    private Set<String> tags = new HashSet<String>();
    private int itemsHandlingFlags = 0;

    public Client() {
        dataPackageLocation = OS.startsWith("windows") ? windowsDataPackageCache : otherDataPackageCache;
        if (this.dataPackage == null) {
            this.dataPackage = new DataPackage();
        }
        this.UUID = this.dataPackage.getUUID();
        this.eventManager = new EventManager();
        this.locationManager = new LocationManager(this);
        this.itemManager = new ItemManager(this);
        client = this;
    }

    public void setGame(String game) {
        this.game = game;
    }

    public void setTags(Set<String> tags) {
        if (!this.tags.equals(tags)) {
            this.tags = tags;
            if (this.isConnected()) {
                ConnectUpdatePacket packet = new ConnectUpdatePacket();
                packet.tags = this.tags;
                this.webSocket.sendPacket(packet);
            }
        }
    }

    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
            if (this.isConnected()) {
                ConnectUpdatePacket packet = new ConnectUpdatePacket();
                packet.tags = this.tags;
                this.webSocket.sendPacket(packet);
            }
        }
    }

    public void removeTag(String tag) {
        if (this.tags.contains(tag)) {
            this.tags.remove(tag);
            if (this.isConnected()) {
                ConnectUpdatePacket packet = new ConnectUpdatePacket();
                packet.tags = this.tags;
                this.webSocket.sendPacket(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataPackage() {
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            File directoryPath = dataPackageLocation.toFile();
            if (directoryPath.exists() && directoryPath.isDirectory()) {
                HashMap<String, File> localGamesList = new HashMap<String, File>();
                for (File gameDir : directoryPath.listFiles()) {
                    if (!gameDir.isDirectory()) continue;
                    localGamesList.put(gameDir.getName(), gameDir);
                }
                if (localGamesList.isEmpty()) {
                    boolean success = directoryPath.mkdirs();
                    if (success) {
                        LOGGER.info("DataPackage directory didn't exist. Starting from a new one.");
                    } else {
                        LOGGER.severe("Failed to make directories for datapackage cache.");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                for (String gameName : this.games) {
                    File dir = (File)localGamesList.get(gameName);
                    if (null == dir) continue;
                    for (File version : dir.listFiles()) {
                        String versionStr = this.versions.get(gameName);
                        if (versionStr == null || !versionStr.equals(version.getName())) continue;
                        try (FileReader reader = new FileReader(version);){
                            this.updateDataPackage((DataPackage)gson.fromJson((Reader)reader, DataPackage.class));
                            LOGGER.info("Read datapackage for Game: ".concat(gameName).concat(" Checksum: ").concat(version.getName()));
                        }
                        catch (IOException e) {
                            LOGGER.info("Failed to read a datapackage. Starting with a new one.");
                        }
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataPackage() {
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            for (String gameName : this.games) {
                String gameVersion;
                File gameFolder = dataPackageLocation.resolve(gameName).toFile();
                if (!gameFolder.exists()) {
                    gameFolder.mkdirs();
                }
                if ((gameVersion = this.versions.get(gameName)) == null) continue;
                File filePath = dataPackageLocation.resolve(gameName).resolve(gameVersion).toFile();
                try (FileWriter writer = new FileWriter(filePath);){
                    gson.toJson((Object)this.dataPackage.getGame(gameName), (Appendable)writer);
                    LOGGER.info("Saving datapackage for Game: ".concat(gameName).concat(" Checksum: ").concat(gameVersion));
                }
                catch (IOException e) {
                    LOGGER.warning("unable to save DataPackage.");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isConnected() {
        return this.webSocket != null && this.webSocket.isOpen();
    }

    public void close() {
        if (this.webSocket != null) {
            this.webSocket.close();
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    void setHintPoints(int hintPoints) {
        this.hintPoints = hintPoints;
    }

    public void setName(String name) {
        this.name = name;
    }

    void setSlot(int slot) {
        this.slot = slot;
    }

    void setTeam(int team) {
        this.team = team;
    }

    void setSlotInfo(HashMap<Integer, NetworkSlot> slotInfo) {
        this.slotInfo = slotInfo;
    }

    void setRoomInfo(RoomInfoPacket roomInfo) {
        this.roomInfo = roomInfo;
    }

    void updateDataPackage(DataPackage newData) {
        this.dataPackage.update(newData);
    }

    public int getTeam() {
        return this.team;
    }

    public int getSlot() {
        return this.slot;
    }

    public RoomInfoPacket getRoomInfo() {
        return this.roomInfo;
    }

    public HashMap<Integer, NetworkSlot> getSlotInfo() {
        return this.slotInfo;
    }

    public void connect(String address) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(!address.contains("//") ? "//" + address : address);
        if (builder.getPort() == -1) {
            builder.setPort(38281);
        }
        if (this.webSocket != null && this.webSocket.isOpen()) {
            LOGGER.fine("previous WebSocket is open, closing.");
            this.webSocket.close();
        }
        if (builder.getScheme() == null) {
            builder.setScheme("wss");
            this.connect(builder.build(), true);
            return;
        }
        this.connect(builder.build());
    }

    public void connect(URI address) {
        this.connect(address, false);
    }

    public void connect(URI address, boolean allowDowngrade) {
        this.connect(address, allowDowngrade, null);
    }

    public void connect(URI address, boolean allowDowngrade, SocketFactory socketFactory) {
        LOGGER.fine("attempting WebSocket connection to " + address.toString());
        this.webSocket = new WebSocket(address, this);
        if (null != socketFactory) {
            this.webSocket.setSocketFactory(socketFactory);
        }
        this.locationManager.setAPWebSocket(this.webSocket);
        this.itemManager.setAPWebSocket(this.webSocket);
        this.webSocket.connect(allowDowngrade);
    }

    public void sendChat(String message) {
        if (this.webSocket == null) {
            return;
        }
        if (this.webSocket.isAuthenticated()) {
            this.webSocket.sendChat(message);
        }
    }

    public boolean checkLocation(long locationID) {
        return this.locationManager.checkLocation(locationID);
    }

    public boolean checkLocations(Collection<Long> locationIDs) {
        return this.locationManager.checkLocations(locationIDs);
    }

    public void scoutLocations(ArrayList<Long> locationIDs) {
        locationIDs.removeIf(location -> !this.dataPackage.getGame((String)this.game).locationNameToId.containsValue(location));
        this.webSocket.scoutLocation(locationIDs);
    }

    public void scoutLocations(ArrayList<Long> locationIDs, CreateAsHint createAsHint) {
        locationIDs.removeIf(location -> !this.dataPackage.getGame((String)this.game).locationNameToId.containsValue(location));
        this.webSocket.scoutlocations(locationIDs, createAsHint.value);
    }

    public abstract void onError(Exception var1);

    public abstract void onClose(String var1, int var2);

    public DataPackage getDataPackage() {
        return this.dataPackage;
    }

    public String getMyName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public int getHintPoints() {
        return this.hintPoints;
    }

    public String getGame() {
        return this.game;
    }

    public String getConnectedAddress() {
        if (this.isConnected()) {
            return this.webSocket.getRemoteSocketAddress().getHostName() + ":" + this.webSocket.getRemoteSocketAddress().getPort();
        }
        return "";
    }

    public void reconnect() {
        this.webSocket.reconnect();
    }

    public String getUUID() {
        return this.UUID;
    }

    public String getAlias() {
        return this.alias;
    }

    void setAlias(String alias) {
        this.alias = alias;
    }

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public void setGameState(ClientStatus status) {
        if (this.webSocket == null) {
            return;
        }
        if (this.webSocket.isAuthenticated()) {
            this.webSocket.sendPacket(new StatusUpdatePacket(status));
        }
    }

    public void sync() {
        this.webSocket.sendPacket(new SyncPacket());
    }

    public void sendBounce(BouncePacket bouncePacket) {
        if (this.webSocket == null) {
            return;
        }
        if (this.webSocket.isAuthenticated()) {
            this.webSocket.sendPacket(bouncePacket);
        }
    }

    public void disconnect() {
        this.webSocket.close();
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int getItemsHandlingFlags() {
        return this.itemsHandlingFlags;
    }

    public void setItemsHandlingFlags(int itemsHandlingFlags) {
        this.itemsHandlingFlags = itemsHandlingFlags;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public int dataStorageSet(SetPacket setPacket) {
        if (this.webSocket == null || !this.webSocket.isAuthenticated()) {
            return 0;
        }
        this.webSocket.sendPacket(setPacket);
        return setPacket.getRequestID();
    }

    public void dataStorageSetNotify(Collection<String> keys) {
        if (this.webSocket == null || !this.webSocket.isAuthenticated()) {
            return;
        }
        this.webSocket.sendPacket(new SetNotifyPacket(keys));
    }

    public int dataStorageGet(Collection<String> keys) {
        if (this.webSocket == null || !this.webSocket.isAuthenticated()) {
            return 0;
        }
        GetPacket getPacket = new GetPacket(keys);
        this.webSocket.sendPacket(getPacket);
        return getPacket.getRequestID();
    }

    static {
        String appData = System.getenv("LOCALAPPDATA");
        String winHome = System.getenv("USERPROFILE");
        String userHome = System.getProperty("user.home");
        windowsDataPackageCache = appData == null || appData.isEmpty() ? Paths.get(winHome, "appdata", "local", "Archipelago", "cache", "datapackage") : Paths.get(appData, "Archipelago", "cache", "datapackage");
        otherDataPackageCache = Paths.get(userHome, ".cache", "Archipelago", "datapackage");
        gson = new Gson();
        protocolVersion = new Version(0, 6, 1);
    }
}

