/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago;

import dev.koifysh.archipelago.events.ArchipelagoEventListener;
import dev.koifysh.archipelago.events.Event;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventManager {
    private final Map<Method, Object> registeredListeners = new ConcurrentHashMap<Method, Object>();

    public void registerListener(Object listener) {
        Method[] methods;
        for (Method method : methods = listener instanceof Class ? ((Class)listener).getMethods() : listener.getClass().getMethods()) {
            if (this.isEventListenerMethod(listener, method)) continue;
            this.registeredListeners.put(method, listener);
        }
    }

    public void unRegisterListener(Object listener) {
        Method[] methods;
        for (Method method : methods = listener instanceof Class ? ((Class)listener).getMethods() : listener.getClass().getMethods()) {
            if (this.isEventListenerMethod(listener, method)) continue;
            this.registeredListeners.remove(method, listener);
        }
    }

    private boolean isEventListenerMethod(Object listener, Method method) {
        if (listener instanceof Class && !Modifier.isStatic(method.getModifiers())) {
            return true;
        }
        if (!method.isAnnotationPresent(ArchipelagoEventListener.class)) {
            return true;
        }
        if (method.getParameterTypes().length != 1) {
            return true;
        }
        return !Event.class.isAssignableFrom(method.getParameterTypes()[0]);
    }

    public void callEvent(Event event) {
        for (Map.Entry<Method, Object> methodObjectEntry : this.registeredListeners.entrySet()) {
            Method method = methodObjectEntry.getKey();
            try {
                if (method.getParameterTypes()[0] != event.getClass()) continue;
                method.invoke(methodObjectEntry.getValue(), event);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
    }
}

