/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago;

import dev.koifysh.archipelago.Client;
import dev.koifysh.archipelago.WebSocket;
import dev.koifysh.archipelago.events.ReceiveItemEvent;
import dev.koifysh.archipelago.network.client.SyncPacket;
import dev.koifysh.archipelago.parts.DataPackage;
import dev.koifysh.archipelago.parts.NetworkItem;
import java.util.ArrayList;

public class ItemManager {
    Client client;
    WebSocket webSocket;
    ArrayList<NetworkItem> receivedItems = new ArrayList();
    int index;

    public ItemManager(Client client) {
        this.client = client;
    }

    public void receiveItems(ArrayList<NetworkItem> ids, int index) {
        if (index == 0) {
            this.receivedItems = new ArrayList();
        }
        if (this.receivedItems.size() == index) {
            this.receivedItems.addAll(ids);
            DataPackage dp = this.client.getDataPackage();
            int myTeam = this.client.getTeam();
            for (int i = this.index; i < this.receivedItems.size(); ++i) {
                NetworkItem item = this.receivedItems.get(i);
                item.itemName = dp.getItem(item.itemID, this.client.getGame());
                item.locationName = dp.getLocation(item.locationID, this.client.getSlotInfo().get((Object)Integer.valueOf((int)item.playerID)).game);
                item.playerName = this.client.getRoomInfo().getPlayer((int)myTeam, (int)item.playerID).alias;
                this.client.getEventManager().callEvent(new ReceiveItemEvent(item, i + 1));
            }
            this.index = this.receivedItems.size();
        } else if (this.webSocket != null) {
            this.webSocket.sendPacket(new SyncPacket());
            this.client.getLocationManager().resendAllCheckedLocations();
        }
    }

    public void writeFromSave(ArrayList<NetworkItem> receivedItems, int index) {
        this.receivedItems = receivedItems;
        this.index = index;
    }

    public void setAPWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public int getIndex() {
        return this.index;
    }

    public ArrayList<NetworkItem> getReceivedItems() {
        return this.receivedItems;
    }

    public ArrayList<Long> getReceivedItemIDs() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NetworkItem receivedItem : this.receivedItems) {
            ids.add(receivedItem.itemID);
        }
        return ids;
    }
}

