/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago;

import dev.koifysh.archipelago.Client;
import dev.koifysh.archipelago.WebSocket;
import dev.koifysh.archipelago.network.client.LocationChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class LocationManager {
    Client client;
    WebSocket webSocket;
    Set<Long> checkedLocations = new HashSet<Long>();
    Set<Long> missingLocations = new HashSet<Long>();

    public LocationManager(Client client) {
        this.client = client;
    }

    public boolean checkLocation(final long id) {
        return this.checkLocations((Collection<Long>)new ArrayList<Long>(1){
            {
                super(arg0);
                this.add(id);
            }
        });
    }

    public boolean checkLocations(Collection<Long> ids) {
        ids.removeIf(location -> !this.missingLocations.contains(location));
        this.checkedLocations.addAll(ids);
        this.missingLocations.removeAll(ids);
        LocationChecks packet = new LocationChecks();
        packet.locations.addAll(ids);
        if (this.webSocket == null) {
            return false;
        }
        if (this.webSocket.isAuthenticated()) {
            this.webSocket.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void sendIfChecked(Set<Long> missingChecks) {
        LocationChecks packet = new LocationChecks();
        packet.locations = new HashSet<Long>();
        for (Long missingCheck : missingChecks) {
            if (!this.checkedLocations.contains(missingCheck)) continue;
            packet.locations.add(missingCheck);
        }
        if (this.webSocket != null && !packet.locations.isEmpty()) {
            this.webSocket.sendPacket(packet);
        }
    }

    public void resendAllCheckedLocations() {
        if (this.webSocket == null) {
            return;
        }
        LocationChecks packet = new LocationChecks();
        packet.locations = this.checkedLocations;
        this.webSocket.sendPacket(packet);
    }

    protected void setAPWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public Set<Long> getCheckedLocations() {
        return this.checkedLocations;
    }

    public Set<Long> getMissingLocations() {
        return this.missingLocations;
    }

    public void addCheckedLocations(Set<Long> newLocations) {
        this.checkedLocations.addAll(newLocations);
        this.missingLocations.removeAll(newLocations);
    }

    public void setMissingLocations(HashSet<Long> missingLocations) {
        this.missingLocations = missingLocations;
    }
}

