/*
 * Decompiled with CFR 0.152.
 */
package dev.koifysh.archipelago.helper;

import dev.koifysh.archipelago.Client;
import dev.koifysh.archipelago.events.DeathLinkEvent;
import dev.koifysh.archipelago.network.client.BouncePacket;
import dev.koifysh.archipelago.network.server.BouncedPacket;
import java.util.HashMap;

public class DeathLink {
    private static double lastDeath = 0.0;

    public static void receiveDeathLink(BouncedPacket bounced) {
        try {
            if ((Double)bounced.data.getOrDefault("time", 0.0) == lastDeath) {
                return;
            }
            DeathLinkEvent dl = new DeathLinkEvent((String)bounced.data.get("source"), (String)bounced.data.get("cause"), (Double)bounced.data.get("time"));
            Client.client.getEventManager().callEvent(dl);
        }
        catch (ClassCastException ex) {
            System.out.println("Error Receiving DeathLink, possible malformed bounce packet");
        }
    }

    public static void SendDeathLink(final String source, final String cause) {
        lastDeath = (double)System.currentTimeMillis() / 1000.0;
        BouncePacket deathLinkPacket = new BouncePacket();
        deathLinkPacket.tags = new String[]{"DeathLink"};
        deathLinkPacket.setData(new HashMap<String, Object>(){
            {
                this.put("cause", cause);
                this.put("time", lastDeath);
                this.put("source", source);
            }
        });
        Client.client.sendBounce(deathLinkPacket);
    }

    public static void setDeathLinkEnabled(boolean enabled) {
        if (enabled) {
            Client.client.addTag("DeathLink");
        } else {
            Client.client.removeTag("DeathLink");
        }
    }
}

