/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.builders.GHProjectBuilder;
import de.coho04.githubapi.builders.GHPublicKeyBuilder;
import de.coho04.githubapi.entities.GHProject;
import de.coho04.githubapi.entities.GHPublicKey;
import de.coho04.githubapi.entities.GHUser;
import de.coho04.githubapi.entities.repositories.GHIssue;
import de.coho04.githubapi.entities.repositories.GHRepository;
import de.coho04.githubapi.utilities.HttpRequestHelper;
import java.util.List;
import org.json.JSONObject;

public class SelfUser
extends GHUser {
    public SelfUser(Github github, JSONObject jsonObject) {
        super(github, jsonObject);
    }

    public static SelfUser getSelfUser(Github github) {
        String response = HttpRequestHelper.sendGetRequest(SelfUser.getBaseUrl() + "/user", github.getToken());
        assert (response != null);
        return new SelfUser(github, new JSONObject(response));
    }

    public List<GHIssue> getIssues() {
        return this.fetchPaginatedData("/issues", jsonObject -> new GHIssue(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHUser> getBlockedUsers() {
        return this.fetchPaginatedData("/user/blocks", jsonObject -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public void followUser(String username) {
        this.sendPutRequest(SelfUser.getBaseUrl() + "/user/following/" + username, this.github.getToken(), null);
    }

    public void unfollowUser(String username) {
        this.sendDeleteRequest(SelfUser.getBaseUrl() + "/user/following/" + username, this.github.getToken());
    }

    public GHPublicKeyBuilder addPublicKey() {
        return new GHPublicKeyBuilder(this.github);
    }

    public GHPublicKey addPublicKey(String title, String key) {
        return new GHPublicKeyBuilder(title, key, this.github).build();
    }

    public GHPublicKey getPublicKey(int id) {
        String response = this.sendGetRequest(SelfUser.getBaseUrl() + "/user/keys/" + id, this.github.getToken());
        assert (response != null);
        return new GHPublicKey(new JSONObject(response));
    }

    public void deletePublicKey(int id) {
        this.sendDeleteRequest(SelfUser.getBaseUrl() + "/user/keys/" + id, this.github.getToken());
    }

    public List<GHRepository> listCreatedRepositories() {
        return this.fetchPaginatedData(SelfUser.getBaseUrl(), "/user/repos", (JSONObject jsonObject) -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken()).stream().filter(repo -> repo.getOwner().getLogin().equals(this.getLogin())).toList();
    }

    public List<GHRepository> listRepositoriesWithAccess() {
        return this.fetchPaginatedData(SelfUser.getBaseUrl(), "/user/repos", (JSONObject jsonObject) -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken());
    }

    public String getEmail() {
        return this.sendGetRequest(SelfUser.getBaseUrl() + "/user/email", this.github.getToken());
    }

    public GHProjectBuilder createProject() {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects");
    }

    public GHProject createProject(String name, String body) {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects").setName(name).setBody(body).build();
    }
}

