/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.builders;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.GHBase;
import de.coho04.githubapi.entities.repositories.GHIssue;
import de.coho04.githubapi.entities.repositories.GHMilestone;
import de.coho04.githubapi.enums.GHState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GHIssueBuilder
extends GHBase {
    private final Github github;
    private final String url;
    private String title;
    private String body;
    private GHMilestone milestone;
    private final List<String> labels = new ArrayList<String>();
    private final List<String> assignees = new ArrayList<String>();
    private final GHState state = GHState.OPEN;

    public GHIssueBuilder(Github github, String url, String title) {
        this.title = title;
        this.url = url;
        this.github = github;
    }

    public GHIssueBuilder(Github github, String url, String title, String body) {
        this.title = title;
        this.body = body;
        this.url = url;
        this.github = github;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GHIssueBuilder assignee(String user) {
        this.assignees.add(user);
        return this;
    }

    public GHIssueBuilder addLabel(String label) {
        this.labels.add(label);
        return this;
    }

    public GHIssue create() {
        JSONObject object = this.toJSONObject();
        if (object.has("state")) {
            object.remove("state");
        }
        String response = this.sendPostRequest(this.getUrl() + "/issues", this.github.getToken(), object);
        return new GHIssue(this.github, new JSONObject(response));
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setMilestone(GHMilestone milestone) {
        this.milestone = milestone;
    }

    public Github getGithub() {
        return this.github;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public GHMilestone getMilestone() {
        return this.milestone;
    }

    public GHState getState() {
        return this.state;
    }

    public List<String> getAssignees() {
        return this.assignees;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = super.toJSONObject().put("title", this.title).put("body", this.body).put("labels", new JSONArray((Collection<?>)this.labels)).put("state", this.state.toString()).put("assignees", new JSONArray((Collection<?>)this.assignees));
        if (this.milestone != null) {
            jsonObject.put("milestone", this.milestone.toJSONObject());
        }
        return jsonObject;
    }
}

