/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.builders;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.GHBase;
import de.coho04.githubapi.entities.GHTeam;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GHTeamBuilder
extends GHBase {
    private final Github github;
    private String name;
    private String description;
    private List<String> maintainers;
    private List<String> repoNames;
    private String privacy;
    private String notificationSetting;
    private String permission;
    private int parentTeamId;
    private final String url;

    public GHTeamBuilder(Github github, String url) {
        this.github = github;
        this.url = url;
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("name", this.name).put("description", this.description).put("maintainers", new JSONArray((Collection<?>)this.maintainers)).put("repo_names", new JSONArray((Collection<?>)this.repoNames)).put("privacy", this.privacy).put("notification_setting", this.notificationSetting).put("permission", this.permission).put("parent_team_id", this.parentTeamId);
    }

    public GHTeamBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public GHTeamBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public GHTeamBuilder setMaintainers(List<String> maintainers) {
        this.maintainers = maintainers;
        return this;
    }

    public GHTeamBuilder setNotificationSetting(String notificationSetting) {
        this.notificationSetting = notificationSetting;
        return this;
    }

    public GHTeamBuilder setParentTeamId(int parentTeamId) {
        this.parentTeamId = parentTeamId;
        return this;
    }

    public GHTeamBuilder setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public GHTeamBuilder setPrivacy(String privacy) {
        this.privacy = privacy;
        return this;
    }

    public GHTeamBuilder setRepoNames(List<String> repoNames) {
        this.repoNames = repoNames;
        return this;
    }

    public GHTeam build() {
        String response = this.sendPostRequest(this.url, this.github.getToken(), this.toJSONObject());
        return new GHTeam(new JSONObject(response));
    }
}

