/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.GHBase;
import de.coho04.githubapi.entities.GHUser;
import de.coho04.githubapi.entities.GHVulnerability;
import java.time.OffsetDateTime;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GHAdvisory
extends GHBase {
    private final int id;
    private final String ghsaId;
    private final String cveId;
    private final String url;
    private final String htmlUrl;
    private final String repositoryAdvisoryUrl;
    private final String summary;
    private final String description;
    private final String type;
    private final String severity;
    private final String sourceCodeLocation;
    private final List<JSONObject> identifiers;
    private final List<String> references;
    private final OffsetDateTime publishedAt;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime githubReviewedAt;
    private final OffsetDateTime nvdPublishedAt;
    private final OffsetDateTime withdrawnAt;
    private final List<GHVulnerability> vulnerabilities;
    private final JSONObject cvss;
    private final JSONArray cwes;
    private final List<GHUser> credits;

    public GHAdvisory(Github github, JSONObject jsonObject) {
        this.id = this.getIntOrNull(jsonObject, "id");
        this.ghsaId = this.getStringOrNull(jsonObject, "ghsa_id");
        this.cveId = this.getStringOrNull(jsonObject, "cve_id");
        this.url = this.getStringOrNull(jsonObject, "url");
        this.htmlUrl = this.getStringOrNull(jsonObject, "html_url");
        this.repositoryAdvisoryUrl = this.getStringOrNull(jsonObject, "repository_advisory_url");
        this.summary = this.getStringOrNull(jsonObject, "summary");
        this.description = this.getStringOrNull(jsonObject, "description");
        this.type = this.getStringOrNull(jsonObject, "type");
        this.severity = this.getStringOrNull(jsonObject, "severity");
        this.sourceCodeLocation = this.getStringOrNull(jsonObject, "source_code_location");
        this.identifiers = this.getArrayOrNull(jsonObject, "identifiers", JSONObject::new).stream().toList();
        this.references = this.getJSONArrayToStringList(jsonObject, "references");
        this.publishedAt = this.getLocalDateOrNull(jsonObject, "published_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.githubReviewedAt = this.getLocalDateOrNull(jsonObject, "github_reviewed_at");
        this.nvdPublishedAt = this.getLocalDateOrNull(jsonObject, "nvd_published_at");
        this.withdrawnAt = this.getLocalDateOrNull(jsonObject, "withdrawn_at");
        this.vulnerabilities = this.getArrayOrNull(jsonObject, "vulnerabilities", json -> new GHVulnerability(github, json));
        this.cvss = jsonObject.getJSONObject("cvss");
        this.cwes = jsonObject.getJSONArray("cwes");
        this.credits = this.getArrayOrNull(jsonObject, "credits", json -> new GHUser(github, json));
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getType() {
        return this.type;
    }

    public JSONArray getCwes() {
        return this.cwes;
    }

    public int getId() {
        return this.id;
    }

    public JSONObject getCvss() {
        return this.cvss;
    }

    public List<JSONObject> getIdentifiers() {
        return this.identifiers;
    }

    public OffsetDateTime getPublishedAt() {
        return this.publishedAt;
    }

    public List<GHVulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public List<GHUser> getCredits() {
        return this.credits;
    }

    public OffsetDateTime getGithubReviewedAt() {
        return this.githubReviewedAt;
    }

    public OffsetDateTime getNvdPublishedAt() {
        return this.nvdPublishedAt;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public OffsetDateTime getWithdrawnAt() {
        return this.withdrawnAt;
    }

    public String getCveId() {
        return this.cveId;
    }

    public String getGhsaId() {
        return this.ghsaId;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getRepositoryAdvisoryUrl() {
        return this.repositoryAdvisoryUrl;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<String> getReferences() {
        return this.references;
    }
}

