/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.bases.ClassBase;
import de.coho04.githubapi.entities.GHWorkflowRun;
import java.time.OffsetDateTime;
import org.json.JSONObject;

public class GHArtifact
extends ClassBase {
    private final String name;
    private final int sizeInBytes;
    private final String archiveDownloadUrl;
    private final boolean expired;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime expiresAt;
    private final OffsetDateTime updatedAt;
    private final GHWorkflowRun workflowRun;

    public GHArtifact(JSONObject jsonObject) {
        super(jsonObject);
        this.name = this.getStringOrNull(jsonObject, "name");
        this.sizeInBytes = this.getIntOrNull(jsonObject, "size_in_bytes");
        this.archiveDownloadUrl = this.getStringOrNull(jsonObject, "archive_download_url");
        this.expired = this.getBooleanOrNull(jsonObject, "expired");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.expiresAt = this.getLocalDateOrNull(jsonObject, "expires_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.workflowRun = new GHWorkflowRun(this.getJSONObjectOrNull(jsonObject, "workflow_run"));
    }

    public String getName() {
        return this.name;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public GHWorkflowRun getWorkflowRun() {
        return this.workflowRun;
    }

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public String getArchiveDownloadUrl() {
        return this.archiveDownloadUrl;
    }

    public boolean isExpired() {
        return this.expired;
    }
}

