/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.bases.GHBase;
import java.time.OffsetDateTime;
import java.util.List;
import org.json.JSONObject;

public class GHHook
extends GHBase {
    private final int id;
    private final String url;
    private final String pingUrl;
    private final String deliveriesUrl;
    private final String name;
    private List<String> events;
    private final boolean active;
    private final JSONObject config;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime createdAt;
    private final String type;

    public GHHook(JSONObject jsonObject) {
        this.id = this.getIntOrNull(jsonObject, "id");
        this.url = this.getStringOrNull(jsonObject, "url");
        this.pingUrl = this.getStringOrNull(jsonObject, "ping_url");
        this.deliveriesUrl = this.getStringOrNull(jsonObject, "deliveries_url");
        this.name = this.getStringOrNull(jsonObject, "name");
        if (jsonObject.has("events") && !jsonObject.isNull("events")) {
            this.events = this.getJSONArrayToStringList(jsonObject, "events");
        }
        this.active = this.getBooleanOrNull(jsonObject, "active");
        this.config = this.getJSONObjectOrNull(jsonObject, "config");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.type = this.getStringOrNull(jsonObject, "type");
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public JSONObject getConfig() {
        return this.config;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getDeliveriesUrl() {
        return this.deliveriesUrl;
    }

    public String getPingUrl() {
        return this.pingUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isActive() {
        return this.active;
    }
}

