/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.bases.GHBase;
import de.coho04.githubapi.entities.HttpsCertificate;
import java.time.OffsetDateTime;
import org.json.JSONObject;

public class GHPages
extends GHBase {
    private final String url;
    private final String status;
    private final String cname;
    private final boolean custom404;
    private final String htmlUrl;
    private final JSONObject source;
    private final boolean isPublic;
    private final OffsetDateTime pendingDomainUnverifiedAt;
    private final String protectedDomainState;
    private final HttpsCertificate httpsCertificate;
    private final boolean httpsEnforced;

    public GHPages(JSONObject jsonObject) {
        this.url = this.getStringOrNull(jsonObject, "url");
        this.status = this.getStringOrNull(jsonObject, "status");
        this.cname = this.getStringOrNull(jsonObject, "cname");
        this.custom404 = this.getBooleanOrNull(jsonObject, "custom_404");
        this.htmlUrl = this.getStringOrNull(jsonObject, "html_url");
        this.source = this.getJSONObjectOrNull(jsonObject, "source");
        this.isPublic = this.getBooleanOrNull(jsonObject, "is_public");
        this.pendingDomainUnverifiedAt = this.getLocalDateOrNull(jsonObject, "pending_domain_unverified_at");
        this.protectedDomainState = this.getStringOrNull(jsonObject, "protected_domain_state");
        this.httpsCertificate = new HttpsCertificate(jsonObject.getJSONObject("https_certificate"));
        this.httpsEnforced = this.getBooleanOrNull(jsonObject, "https_enforced");
    }

    public String getUrl() {
        return this.url;
    }

    public HttpsCertificate getHttpsCertificate() {
        return this.httpsCertificate;
    }

    public JSONObject getSource() {
        return this.source;
    }

    public OffsetDateTime getPendingDomainUnverifiedAt() {
        return this.pendingDomainUnverifiedAt;
    }

    public String getCname() {
        return this.cname;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getProtectedDomainState() {
        return this.protectedDomainState;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isCustom404() {
        return this.custom404;
    }

    public boolean isHttpsEnforced() {
        return this.httpsEnforced;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

