/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.ClassBase;
import de.coho04.githubapi.entities.GHUser;
import java.time.OffsetDateTime;
import org.json.JSONObject;

public class GHProject
extends ClassBase {
    private final String ownerUrl;
    private final String columnsUrl;
    private final String name;
    private final String body;
    private final int number;
    private final String state;
    private final GHUser creator;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final String organizationPermission;
    private final boolean isPrivate;

    public GHProject(Github github, JSONObject jsonObject) {
        super(jsonObject);
        this.ownerUrl = this.getStringOrNull(jsonObject, "owner_url");
        this.columnsUrl = this.getStringOrNull(jsonObject, "columns_url");
        this.name = this.getStringOrNull(jsonObject, "name");
        this.body = this.getStringOrNull(jsonObject, "body");
        this.number = this.getIntOrNull(jsonObject, "number");
        this.state = this.getStringOrNull(jsonObject, "state");
        this.creator = new GHUser(github, jsonObject.getJSONObject("creator"));
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.organizationPermission = this.getStringOrNull(jsonObject, "organization_permission");
        this.isPrivate = this.getBooleanOrNull(jsonObject, "private");
    }

    public String getName() {
        return this.name;
    }

    public GHUser getCreator() {
        return this.creator;
    }

    public int getNumber() {
        return this.number;
    }

    public String getBody() {
        return this.body;
    }

    public String getColumnsUrl() {
        return this.columnsUrl;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getOrganizationPermission() {
        return this.organizationPermission;
    }

    public String getOwnerUrl() {
        return this.ownerUrl;
    }

    public String getState() {
        return this.state;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

