/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.ClassBase;
import de.coho04.githubapi.entities.GHUser;
import de.coho04.githubapi.entities.repositories.GHLabel;
import de.coho04.githubapi.entities.repositories.GHMilestone;
import de.coho04.githubapi.enums.GHState;
import java.time.OffsetDateTime;
import java.util.List;
import org.json.JSONObject;

public class GHPullRequest
extends ClassBase {
    private final String diffUrl;
    private final String patchUrl;
    private final String issueUrl;
    private final String commitsUrl;
    private final String reviewCommentsUrl;
    private final String reviewCommentUrl;
    private final String commentsUrl;
    private final String statusesUrl;
    private final int number;
    private GHState state;
    private final boolean locked;
    private final String title;
    private final GHUser user;
    private final String body;
    private final List<GHLabel> labels;
    private GHMilestone milestone;
    private final String activeLockReason;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime closedAt;
    private final OffsetDateTime mergedAt;
    private final String mergeCommitSha;
    private GHUser assignee;
    private final List<GHUser> assignees;
    private final List<GHUser> requestedReviewers;
    private final List<GHUser> requestedTeams;
    private final String authorAssociation;
    private final String autoMerge;
    private final boolean draft;

    public GHPullRequest(Github github, JSONObject jsonObject) {
        super(jsonObject);
        this.diffUrl = this.getStringOrNull(jsonObject, "diff_url");
        this.patchUrl = this.getStringOrNull(jsonObject, "patch_url");
        this.issueUrl = this.getStringOrNull(jsonObject, "issue_url");
        this.commitsUrl = this.getStringOrNull(jsonObject, "commits_url");
        this.reviewCommentsUrl = this.getStringOrNull(jsonObject, "review_comments_url");
        this.reviewCommentUrl = this.getStringOrNull(jsonObject, "review_comment_url");
        this.commentsUrl = this.getStringOrNull(jsonObject, "comments_url");
        this.statusesUrl = this.getStringOrNull(jsonObject, "statuses_url");
        this.number = this.getIntOrNull(jsonObject, "number");
        if (jsonObject.has("state")) {
            this.state = GHState.fromString(this.getStringOrNull(jsonObject, "state"));
        }
        this.locked = this.getBooleanOrNull(jsonObject, "locked");
        this.title = this.getStringOrNull(jsonObject, "title");
        this.user = new GHUser(github, jsonObject.getJSONObject("user"));
        this.body = this.getStringOrNull(jsonObject, "body");
        this.labels = this.getArrayOrNull(jsonObject, "labels", GHLabel::new);
        this.activeLockReason = this.getStringOrNull(jsonObject, "active_lock_reason");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.closedAt = this.getLocalDateOrNull(jsonObject, "closed_at");
        this.mergedAt = this.getLocalDateOrNull(jsonObject, "merged_at");
        this.mergeCommitSha = this.getStringOrNull(jsonObject, "merge_commit_sha");
        this.assignees = this.getArrayOrNull(jsonObject, "assignees", json -> new GHUser(github, json));
        this.requestedReviewers = this.getArrayOrNull(jsonObject, "requested_reviewers", json -> new GHUser(github, json));
        this.requestedTeams = this.getArrayOrNull(jsonObject, "requested_teams", json -> new GHUser(github, json));
        this.authorAssociation = this.getStringOrNull(jsonObject, "author_association");
        this.autoMerge = this.getStringOrNull(jsonObject, "auto_merge");
        this.draft = this.getBooleanOrNull(jsonObject, "draft");
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public GHState getState() {
        return this.state;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    public GHMilestone getMilestone() {
        return this.milestone;
    }

    public GHUser getAssignee() {
        return this.assignee;
    }

    public GHUser getUser() {
        return this.user;
    }

    public List<GHLabel> getLabels() {
        return this.labels;
    }

    public String getActiveLockReason() {
        return this.activeLockReason;
    }

    public String getIssueUrl() {
        return this.issueUrl;
    }

    public List<GHUser> getAssignees() {
        return this.assignees;
    }

    public List<GHUser> getRequestedTeams() {
        return this.requestedTeams;
    }

    public List<GHUser> getRequestedReviewers() {
        return this.requestedReviewers;
    }

    public OffsetDateTime getClosedAt() {
        return this.closedAt;
    }

    public String getCommentsUrl() {
        return this.commentsUrl;
    }

    public String getCommitsUrl() {
        return this.commitsUrl;
    }

    public String getDiffUrl() {
        return this.diffUrl;
    }

    public OffsetDateTime getMergedAt() {
        return this.mergedAt;
    }

    public String getAuthorAssociation() {
        return this.authorAssociation;
    }

    public String getMergeCommitSha() {
        return this.mergeCommitSha;
    }

    public String getPatchUrl() {
        return this.patchUrl;
    }

    public String getReviewCommentsUrl() {
        return this.reviewCommentsUrl;
    }

    public String getReviewCommentUrl() {
        return this.reviewCommentUrl;
    }

    public String getAutoMerge() {
        return this.autoMerge;
    }

    public String getStatusesUrl() {
        return this.statusesUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isDraft() {
        return this.draft;
    }
}

