/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.EntityBase;
import de.coho04.githubapi.entities.GHPublicKey;
import de.coho04.githubapi.entities.repositories.GHRepository;
import de.coho04.githubapi.utilities.HttpRequestHelper;
import java.util.List;
import org.json.JSONObject;

public class GHUser
extends EntityBase {
    private final String gistsUrl;
    private final String gravatarId;
    private final boolean siteAdmin;
    private final String starredUrl;
    private final int contributions;
    private final String followingUrl;
    private final String followersUrl;
    private final String subscriptionsUrl;
    private final String receivedEventsUrl;
    private final String organizationsUrl;
    protected final Github github;

    public GHUser(Github github, JSONObject jsonObject) {
        super(jsonObject);
        this.github = github;
        this.contributions = this.getIntOrNull(jsonObject, "contributions");
        this.gistsUrl = this.getStringOrNull(jsonObject, "gists_url");
        this.siteAdmin = this.getBooleanOrNull(jsonObject, "site_admin");
        this.gravatarId = this.getStringOrNull(jsonObject, "gravatar_id");
        this.starredUrl = this.getStringOrNull(jsonObject, "starred_url");
        this.followersUrl = this.getStringOrNull(jsonObject, "followers_url");
        this.followingUrl = this.getStringOrNull(jsonObject, "following_url");
        this.subscriptionsUrl = this.getStringOrNull(jsonObject, "subscriptions_url");
        this.receivedEventsUrl = this.getStringOrNull(jsonObject, "received_events_url");
        this.organizationsUrl = this.getStringOrNull(jsonObject, "organizations_url");
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("gists_url", this.gistsUrl).put("gravatar_id", this.gravatarId).put("site_admin", this.siteAdmin).put("starred_url", this.starredUrl).put("contributions", this.contributions).put("following_url", this.followingUrl).put("followers_url", this.followersUrl).put("subscriptions_url", this.subscriptionsUrl).put("received_events_url", this.receivedEventsUrl).put("organizations_url", this.organizationsUrl);
    }

    public static GHUser getUser(Github github, String name) {
        String response = HttpRequestHelper.sendGetRequest(GHUser.getBaseUrl() + "/users/" + name, github.getToken());
        assert (response != null);
        JSONObject json = new JSONObject(response);
        return new GHUser(github, json);
    }

    public String getFollowersUrl() {
        return this.followersUrl;
    }

    public String getFollowingUrl() {
        return this.followingUrl;
    }

    public String getGistsUrl() {
        return this.gistsUrl;
    }

    public String getReceivedEventsUrl() {
        return this.receivedEventsUrl;
    }

    public String getStarredUrl() {
        return this.starredUrl;
    }

    public String getSubscriptionsUrl() {
        return this.subscriptionsUrl;
    }

    public String getGravatarId() {
        return this.gravatarId;
    }

    public String getOrganizationsUrl() {
        return this.organizationsUrl;
    }

    public int getContributions() {
        return this.contributions;
    }

    public boolean isSiteAdmin() {
        return this.siteAdmin;
    }

    public GHRepository findRepositoryByName(String name) {
        return GHRepository.getRepository(this.github, this.getLogin(), name);
    }

    public List<GHUser> getFollowers() {
        return this.fetchPaginatedData(this.getUrl(), "/followers", (JSONObject jsonObject) -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHUser> getFollowing() {
        return this.fetchPaginatedData(this.getUrl(), "/following", (JSONObject jsonObject) -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHPublicKey> getPublicKeys() {
        return this.fetchPaginatedData(this.getUrl(), "/keys", GHPublicKey::new, this.github.getToken());
    }

    public List<GHRepository> listRepositories() {
        return this.fetchPaginatedData(this.getUrl(), "/repos", (JSONObject jsonObject) -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken());
    }
}

