/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.entities.repositories;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.bases.ClassBase;
import de.coho04.githubapi.entities.GHUser;
import de.coho04.githubapi.enums.GHState;
import java.time.OffsetDateTime;
import org.json.JSONObject;

public class GHMilestone
extends ClassBase {
    private final int number;
    private final String title;
    private final String dueOn;
    private GHState state;
    private GHUser creator;
    private final int openIssues;
    private final OffsetDateTime closedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final int closedIssues;
    private final String labelsUrl;
    private final String description;

    public GHMilestone(Github github, JSONObject jsonObject) {
        super(jsonObject);
        if (jsonObject.has("creator")) {
            this.creator = new GHUser(github, jsonObject.getJSONObject("creator"));
        }
        this.closedAt = this.getLocalDateOrNull(jsonObject, "closed_at");
        this.description = this.getStringOrNull(jsonObject, "description");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.title = this.getStringOrNull(jsonObject, "title");
        this.closedIssues = this.getIntOrNull(jsonObject, "closed_issues");
        this.dueOn = this.getStringOrNull(jsonObject, "due_on");
        this.labelsUrl = this.getStringOrNull(jsonObject, "labels_url");
        this.number = this.getIntOrNull(jsonObject, "number");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        if (jsonObject.has("state")) {
            this.state = GHState.fromString(this.getStringOrNull(jsonObject, "state"));
        }
        this.openIssues = this.getIntOrNull(jsonObject, "open_issues");
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("closed_at", this.closedAt.toString()).put("description", this.description).put("created_at", this.createdAt.toString()).put("title", this.title).put("closed_issues", this.closedIssues).put("due_on", this.dueOn).put("labels_url", this.labelsUrl).put("number", this.number).put("updated_at", this.updatedAt.toString()).put("state", this.state.toString()).put("creator", this.creator.toJSONObject()).put("open_issues", this.openIssues);
    }

    public String getDescription() {
        return this.description;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getLabelsUrl() {
        return this.labelsUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getClosedAt() {
        return this.closedAt;
    }

    public int getNumber() {
        return this.number;
    }

    public GHState getState() {
        return this.state;
    }

    public GHUser getCreator() {
        return this.creator;
    }

    public int getClosedIssues() {
        return this.closedIssues;
    }

    public int getOpenIssues() {
        return this.openIssues;
    }

    public String getDueOn() {
        return this.dueOn;
    }
}

