/*
 * Decompiled with CFR 0.152.
 */
package de.coho04.githubapi.utilities;

import de.coho04.githubapi.Github;
import de.coho04.githubapi.factories.HttpURLConnectionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class HttpRequestHelper {
    public static HttpURLConnectionFactory connectionFactory = new HttpURLConnectionFactory();

    public static String sendPostRequest(String url, String githubToken, JSONObject jsonObject) {
        String string;
        HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept", "application/vnd.github+json");
        con.addRequestProperty("Authorization", "Bearer " + githubToken);
        con.setDoOutput(true);
        con.getOutputStream().write(jsonObject.toString().getBytes());
        int responseCode = con.getResponseCode();
        if (responseCode != 201) {
            throw new UnsupportedOperationException("Not supported yet. Response Code" + responseCode);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        try {
            string = in.lines().collect(Collectors.joining());
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
        in.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendGetRequest(String url, String githubToken) {
        try {
            HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", "Bearer " + githubToken);
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 404) return null;
                System.out.println("Failed to send GET request to: " + url);
                System.out.println("Response Message: " + con.getResponseMessage());
                System.out.println("Response Code: " + responseCode);
                return null;
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String string = in.lines().collect(Collectors.joining());
                return string;
            }
        }
        catch (IOException exception) {
            if (exception.getMessage().contains("404")) return null;
            Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    public static String[] sendGetRequestWithLinkHeader(String url, String githubToken) {
        try {
            HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", "Bearer " + githubToken);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String responseBody;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                    responseBody = in.lines().collect(Collectors.joining());
                }
                return new String[]{responseBody, con.getHeaderField("Link")};
            }
            System.out.println("Failed to send GET request to: " + url);
            System.out.println("Response Code: " + responseCode);
            return new String[]{null, null};
        }
        catch (IOException exception) {
            Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            return new String[]{null, null};
        }
    }

    public static String extractNextPageUrl(String linkHeader) {
        String[] links;
        if (linkHeader == null) {
            return null;
        }
        for (String link : links = linkHeader.split(", ")) {
            if (!link.contains("rel=\"next\"")) continue;
            int start = link.indexOf(60) + 1;
            int end = link.indexOf(62);
            if (start == -1 || end == -1) continue;
            return link.substring(start, end);
        }
        return null;
    }

    public static void sendDeleteRequest(String url, String githubToken) {
        block3: {
            try {
                HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
                con.setRequestMethod("DELETE");
                con.setRequestProperty("Authorization", "Bearer " + githubToken);
                int responseCode = con.getResponseCode();
                if (responseCode >= 300 || responseCode < 200) {
                    System.out.println("Failed to send DELETE request to: " + url);
                    System.out.println("Response Code: " + responseCode);
                }
            }
            catch (IOException exception) {
                if (exception.getMessage().contains("404")) break block3;
                Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public static boolean sendDeleteRequestWithResponseCode(String url, String githubToken, int responseCode) {
        try {
            HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
            con.setRequestMethod("DELETE");
            con.setRequestProperty("Authorization", "Bearer " + githubToken);
            return responseCode == con.getResponseCode();
        }
        catch (IOException exception) {
            if (!exception.getMessage().contains("404")) {
                Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            }
            return false;
        }
    }

    public static boolean sendGetRequestWithResponseCode(String url, String githubToken, int responseCode) {
        try {
            HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", "Bearer " + githubToken);
            return con.getResponseCode() == responseCode;
        }
        catch (IOException exception) {
            if (!exception.getMessage().contains("404")) {
                Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            }
            return false;
        }
    }

    public static void sendPutRequest(String url, String githubToken, JSONObject jsonObject) {
        try {
            int responseCode;
            HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
            con.setRequestMethod("PUT");
            con.setRequestProperty("Content-Type", "application/json");
            con.addRequestProperty("Authorization", "Bearer " + githubToken);
            con.setDoOutput(true);
            if (jsonObject != null) {
                con.getOutputStream().write(jsonObject.toString().getBytes());
            }
            if ((responseCode = con.getResponseCode()) >= 300 || responseCode < 200) {
                System.out.println("Response Code: " + responseCode);
                System.out.println("Response Message: " + con.getResponseMessage());
                throw new IOException("Failed to send PUT request to: " + url);
            }
        }
        catch (IOException exception) {
            Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public static void sendPatchRequest(String url, String githubToken, JSONObject jsonObject) {
        try {
            int responseCode;
            HttpURLConnection con = connectionFactory.createHttpURLConnection(url);
            con.setRequestMethod("POST");
            con.setRequestProperty("X-HTTP-Method-Override", "PATCH");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Authorization", "Bearer " + githubToken);
            con.setDoOutput(true);
            if (jsonObject != null) {
                con.getOutputStream().write(jsonObject.toString().getBytes());
            }
            if ((responseCode = con.getResponseCode()) >= 300 || responseCode < 200) {
                throw new IOException("Failed to send PATCH request to: " + url);
            }
        }
        catch (IOException exception) {
            Github.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

