/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.builders.GHProjectBuilder;
import io.github.coho04.githubapi.builders.GHPublicKeyBuilder;
import io.github.coho04.githubapi.entities.GHProject;
import io.github.coho04.githubapi.entities.GHPublicKey;
import io.github.coho04.githubapi.entities.GHUser;
import io.github.coho04.githubapi.entities.repositories.GHIssue;
import io.github.coho04.githubapi.entities.repositories.GHRepository;
import io.github.coho04.githubapi.utilities.HttpRequestHelper;
import java.util.List;
import org.json.JSONObject;

public class SelfUser
extends GHUser {
    public SelfUser(Github github, JSONObject jsonObject) {
        super(github, jsonObject);
    }

    public static SelfUser getSelfUser(Github github) {
        String response = HttpRequestHelper.sendGetRequest(GHBase.getBaseUrl() + "/user", github.getToken());
        assert (response != null);
        return new SelfUser(github, new JSONObject(response));
    }

    public List<GHIssue> getIssues() {
        return this.fetchPaginatedData("/issues", jsonObject -> new GHIssue(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHUser> getBlockedUsers() {
        return this.fetchPaginatedData("/user/blocks", jsonObject -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public void followUser(String username) {
        this.sendPutRequest(GHBase.getBaseUrl() + "/user/following/" + username, this.github.getToken(), null);
    }

    public void unfollowUser(String username) {
        this.sendDeleteRequest(GHBase.getBaseUrl() + "/user/following/" + username, this.github.getToken());
    }

    public GHPublicKeyBuilder addPublicKey() {
        return new GHPublicKeyBuilder(this.github);
    }

    public GHPublicKey addPublicKey(String title, String key) {
        return new GHPublicKeyBuilder(title, key, this.github).build();
    }

    public GHPublicKey getPublicKey(int id) {
        String response = this.sendGetRequest(GHBase.getBaseUrl() + "/user/keys/" + id, this.github.getToken());
        assert (response != null);
        return new GHPublicKey(new JSONObject(response));
    }

    public void deletePublicKey(int id) {
        this.sendDeleteRequest(GHBase.getBaseUrl() + "/user/keys/" + id, this.github.getToken());
    }

    public List<GHRepository> listCreatedRepositories() {
        return this.fetchPaginatedData(GHBase.getBaseUrl(), "/user/repos", (JSONObject jsonObject) -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken()).stream().filter(repo -> repo.getOwner().getLogin().equals(this.getLogin())).toList();
    }

    public List<GHRepository> listRepositoriesWithAccess() {
        return this.fetchPaginatedData(GHBase.getBaseUrl(), "/user/repos", (JSONObject jsonObject) -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken());
    }

    public String getEmail() {
        return this.sendGetRequest(GHBase.getBaseUrl() + "/user/email", this.github.getToken());
    }

    public GHProjectBuilder createProject() {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects");
    }

    public GHProject createProject(String name, String body) {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects").setName(name).setBody(body).build();
    }
}

