/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.bases;

import io.github.coho04.githubapi.interfaces.HttpRequestInterface;
import io.github.coho04.githubapi.interfaces.JSONHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.json.JSONArray;
import org.json.JSONObject;

public class GHBase
implements JSONHelper,
HttpRequestInterface {
    public JSONObject toJSONObject() {
        return new JSONObject();
    }

    public static String getBaseUrl() {
        return "https://api.github.com";
    }

    protected <T> List<T> fetchPaginatedData(String endpoint, Function<JSONObject, T> mapper, String token, String params) {
        return this.fetchPaginatedData(GHBase.getBaseUrl(), endpoint + "?per_page=100" + params, mapper, token);
    }

    protected <T> List<T> fetchPaginatedData(String endpoint, Function<JSONObject, T> mapper, String token) {
        return this.fetchPaginatedData(GHBase.getBaseUrl(), endpoint, mapper, token);
    }

    protected <T> List<T> fetchPaginatedData(String url, String endpoint, Function<JSONObject, T> mapper, String token) {
        ArrayList<T> result = new ArrayList<T>();
        url = Objects.requireNonNullElseGet(url, GHBase::getBaseUrl) + endpoint + "?per_page=100";
        while (url != null) {
            String[] responseAndLink = this.sendGetRequestWithLinkHeader((String)url, token);
            String response = responseAndLink[0];
            JSONArray json = new JSONArray(response);
            for (int i = 0; i < json.length(); ++i) {
                JSONObject jsonObject = json.getJSONObject(i);
                result.add(mapper.apply(jsonObject));
            }
            String linkHeader = responseAndLink[1];
            url = this.extractNextPageUrl(linkHeader);
        }
        return result;
    }

    protected <T> List<T> fetchArrayData(String endpoint, Function<JSONObject, T> mapper, String token, String entryPoint) {
        return this.fetchArrayData(GHBase.getBaseUrl(), endpoint, mapper, token, entryPoint);
    }

    protected <T> List<T> fetchArrayData(String url, String endpoint, Function<JSONObject, T> mapper, String token, String entryPoint) {
        ArrayList<T> result = new ArrayList<T>();
        String response = this.sendGetRequest((String)(url = Objects.requireNonNullElseGet(url, GHBase::getBaseUrl) + endpoint), token);
        if (response != null) {
            JSONObject json = new JSONObject(response);
            JSONArray jsonArray = json.getJSONArray(entryPoint);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                result.add(mapper.apply(jsonObject));
            }
        }
        return result;
    }
}

