/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.builders;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.GHHook;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class GHHookBuilder
extends GHBase {
    private final Github github;
    private final String url;
    private String name;
    private boolean active;
    private String configURL;
    private String configContentType;
    private String configSecret;
    private String configInsecureSSL;
    private String configUsername;
    private String configPassword;
    private List<String> events;

    public GHHookBuilder(Github github, String url) {
        this.github = github;
        this.url = url;
        this.events = new ArrayList<String>();
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("name", this.name).put("active", this.active).put("config", new JSONObject().put("url", this.configURL).put("content_type", this.configContentType).put("secret", this.configSecret).put("insecure_ssl", this.configInsecureSSL).put("username", this.configUsername).put("password", this.configPassword)).put("events", this.events).put("active", this.active);
    }

    public void setConfigContentType(String configContentType) {
        this.configContentType = configContentType;
    }

    public void setConfigInsecureSSL(String configInsecureSSL) {
        this.configInsecureSSL = configInsecureSSL;
    }

    public void setConfigPassword(String configPassword) {
        this.configPassword = configPassword;
    }

    public void setConfigSecret(String configSecret) {
        this.configSecret = configSecret;
    }

    public void setConfigURL(String configURL) {
        this.configURL = configURL;
    }

    public void setConfigUsername(String configUsername) {
        this.configUsername = configUsername;
    }

    public void setEvents(List<String> events) {
        this.events = new ArrayList<String>(events);
    }

    public void addEvent(String event) {
        this.events.add(event);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public Github getGithub() {
        return this.github;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getConfigContentType() {
        return this.configContentType;
    }

    public String getConfigInsecureSSL() {
        return this.configInsecureSSL;
    }

    public String getConfigPassword() {
        return this.configPassword;
    }

    public String getConfigSecret() {
        return this.configSecret;
    }

    public String getConfigURL() {
        return this.configURL;
    }

    public String getConfigUsername() {
        return this.configUsername;
    }

    public boolean isActive() {
        return this.active;
    }

    public GHHook build() {
        String response = this.sendPostRequest(this.url, this.github.getToken(), this.toJSONObject());
        assert (response != null);
        return new GHHook(new JSONObject(response));
    }
}

