/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.builders;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.GHProject;
import org.json.JSONObject;

public class GHProjectBuilder
extends GHBase {
    private final Github github;
    private final String url;
    private String name;
    private String body;

    public GHProjectBuilder(Github github, String url) {
        this.github = github;
        this.url = url;
    }

    public GHProjectBuilder setBody(String body) {
        this.body = body;
        return this;
    }

    public GHProjectBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("name", this.name).put("body", this.body);
    }

    public GHProject build() {
        String response = this.sendPostRequest(this.url, this.github.getToken(), this.toJSONObject());
        return new GHProject(this.github, new JSONObject(response));
    }

    public String getName() {
        return this.name;
    }

    public Github getGithub() {
        return this.github;
    }

    public String getBody() {
        return this.body;
    }

    public String getUrl() {
        return this.url;
    }
}

