/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.builders;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.GHPublicKey;
import org.json.JSONObject;

public class GHPublicKeyBuilder
extends GHBase {
    private String title;
    private String key;
    private final Github github;

    public GHPublicKeyBuilder(Github github) {
        this.github = github;
    }

    public GHPublicKeyBuilder(String title, String key, Github github) {
        this.title = title;
        this.key = key;
        this.github = github;
    }

    public GHPublicKeyBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public GHPublicKeyBuilder setKey(String key) {
        this.key = key;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Github getGithub() {
        return this.github;
    }

    public String getKey() {
        return this.key;
    }

    public GHPublicKey build() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("title", this.title);
        jsonObject.put("key", this.key);
        String response = this.sendPostRequest("https://api.github.com/user/keys", this.github.getToken(), jsonObject);
        return new GHPublicKey(new JSONObject(response));
    }
}

