/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.GHPackage;
import java.util.List;
import org.json.JSONObject;

public class GHVulnerability
extends GHBase {
    private GHPackage ghPackage;
    private final String firstPatchedVersion;
    private final String vulnerableVersionRange;
    private final List<String> vulnerableFunctions;

    public GHVulnerability(Github github, JSONObject jsonObject) {
        if (jsonObject.has("package") && !jsonObject.isNull("package")) {
            this.ghPackage = new GHPackage(github, jsonObject.getJSONObject("package"));
        }
        this.firstPatchedVersion = this.getStringOrNull(jsonObject, "first_patched_version");
        this.vulnerableVersionRange = this.getStringOrNull(jsonObject, "vulnerable_version_range");
        this.vulnerableFunctions = this.getJSONArrayToStringList(jsonObject, "vulnerable_functions");
    }

    public GHPackage getGhPackage() {
        return this.ghPackage;
    }

    public String getFirstPatchedVersion() {
        return this.firstPatchedVersion;
    }

    public String getVulnerableVersionRange() {
        return this.vulnerableVersionRange;
    }

    public List<String> getVulnerableFunctions() {
        return this.vulnerableFunctions;
    }
}

