/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities.repositories;

import io.github.coho04.githubapi.bases.GHBase;
import org.json.JSONObject;

public class GHBranch
extends GHBase {
    private final boolean isProtected;
    private final String name;
    private final String commitSha;
    private final String commitUrl;

    public GHBranch(JSONObject jsonObject) {
        this.isProtected = this.getBooleanOrNull(jsonObject, "protected");
        this.name = this.getStringOrNull(jsonObject, "name");
        this.commitSha = this.getStringOrNull(jsonObject.getJSONObject("commit"), "sha");
        this.commitUrl = this.getStringOrNull(jsonObject.getJSONObject("commit"), "url");
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("protected", this.isProtected).put("name", this.name).put("commit", new JSONObject().put("sha", this.commitSha).put("url", this.commitUrl));
    }

    public String getName() {
        return this.name;
    }

    public String getCommitSha() {
        return this.commitSha;
    }

    public String getCommitUrl() {
        return this.commitUrl;
    }

    public boolean isProtected() {
        return this.isProtected;
    }
}

