/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.interfaces;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public interface JSONHelper {
    default public String getStringOrNull(JSONObject jsonObject, String key) {
        return jsonObject.isNull(key) ? null : jsonObject.getString(key);
    }

    default public Integer getIntOrNull(JSONObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return 0;
        }
        return jsonObject.isNull(key) ? 0 : jsonObject.getInt(key);
    }

    default public Long getLongOrNull(JSONObject jsonObject, String key) {
        return jsonObject.isNull(key) ? 0L : jsonObject.getLong(key);
    }

    default public boolean getBooleanOrNull(JSONObject jsonObject, String key) {
        return !jsonObject.isNull(key) && jsonObject.getBoolean(key);
    }

    default public JSONObject getJSONObjectOrNull(JSONObject jsonObject, String key) {
        return jsonObject.isNull(key) ? null : jsonObject.getJSONObject(key);
    }

    default public OffsetDateTime getLocalDateOrNull(JSONObject jsonObject, String key) {
        return jsonObject.isNull(key) ? null : OffsetDateTime.parse(jsonObject.getString(key));
    }

    default public <T> List<T> getArrayOrNull(JSONObject jsonObject, String key, JSONToObject<T> factory) {
        ArrayList<T> list = new ArrayList<T>();
        if (jsonObject.isNull(key)) {
            return list;
        }
        JSONArray jsonArray = jsonObject.getJSONArray(key);
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(factory.apply(jsonArray.getJSONObject(i)));
        }
        return list;
    }

    default public List<String> getJSONArrayToStringList(JSONObject jsonObject, String key) {
        ArrayList<String> list = new ArrayList<String>();
        if (jsonObject.isNull(key)) {
            return list;
        }
        JSONArray jsonArray = jsonObject.getJSONArray(key);
        if (jsonArray.isEmpty()) {
            return list;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.getString(i));
        }
        return list;
    }

    @FunctionalInterface
    public static interface JSONToObject<T> {
        public T apply(JSONObject var1);
    }
}

