/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi;

import io.github.coho04.githubapi.SelfUser;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.GHAdvisory;
import io.github.coho04.githubapi.entities.GHGitignoreTemplate;
import io.github.coho04.githubapi.entities.GHOrganisation;
import io.github.coho04.githubapi.entities.GHUser;
import io.github.coho04.githubapi.utilities.LogFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Github
extends GHBase {
    private final String token;
    private static Logger logger;

    public Github(String token) {
        this.token = token;
        logger = Logger.getLogger("global");
        logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        logger.addHandler(handler);
    }

    public GHOrganisation findOrganisationByName(String name) {
        return GHOrganisation.getOrganisation(this, name);
    }

    public GHUser findUserByName(String name) {
        return GHUser.getUser(this, name);
    }

    public String getToken() {
        return this.token;
    }

    public List<GHAdvisory> listGlobalAdvisories() {
        return this.fetchPaginatedData("/advisories", json -> new GHAdvisory(this, (JSONObject)json), this.getToken());
    }

    public GHAdvisory getGlobalAdvisories(String id) {
        String response = this.sendGetRequest("/advisories/" + id, this.getToken());
        assert (response != null);
        return new GHAdvisory(this, new JSONObject(response));
    }

    public List<GHGitignoreTemplate> listGitignoreTemplates() {
        String response = this.sendGetRequest(Github.getBaseUrl() + "/gitignore/templates", this.getToken());
        assert (response != null);
        ArrayList<GHGitignoreTemplate> templates = new ArrayList<GHGitignoreTemplate>();
        JSONArray array = new JSONArray(response);
        array.toList().forEach(o -> {
            JSONObject json = new JSONObject("{\"name\":\"" + String.valueOf(o) + "\"}");
            templates.add(new GHGitignoreTemplate(json));
        });
        return templates;
    }

    public GHGitignoreTemplate getGitignoreTemplate(String name) {
        String response = this.sendGetRequest(Github.getBaseUrl() + "/gitignore/templates/" + name, this.getToken());
        assert (response != null);
        return new GHGitignoreTemplate(new JSONObject(response));
    }

    public SelfUser getSelfUser() {
        return SelfUser.getSelfUser(this);
    }

    public static Logger getLogger() {
        return logger;
    }
}

