/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.builders;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.repositories.GHBranch;
import io.github.coho04.githubapi.entities.repositories.GHRepository;
import java.util.Base64;
import org.json.JSONObject;

public class GHFileBuilder
extends GHBase {
    private GHBranch branch;
    private String path;
    private String content;
    private String message;
    private final GHRepository repository;
    private final Github github;
    private String sha;

    public GHFileBuilder(GHRepository repository, Github github) {
        this.repository = repository;
        this.github = github;
    }

    public GHFileBuilder(GHRepository repository, GHBranch branch, Github github) {
        this.branch = branch;
        this.github = github;
        this.repository = repository;
    }

    public GHFileBuilder(GHRepository repository, Github github, String sha) {
        assert (repository != null);
        this.repository = repository;
        assert (github != null);
        this.github = github;
        this.sha = sha;
    }

    public GHFileBuilder(GHRepository repository, GHBranch branch, String path, String content, String message, Github github) {
        this.repository = repository;
        this.branch = branch;
        this.path = path;
        this.content = content;
        this.message = message;
        this.github = github;
    }

    public GHFileBuilder setBranch(GHBranch branch) {
        this.branch = branch;
        return this;
    }

    public GHFileBuilder setBranch(String branch) {
        this.branch = this.repository.getBranches().get(branch);
        return this;
    }

    public GHFileBuilder setContent(String content) {
        this.content = content;
        return this;
    }

    public GHFileBuilder setMessage(String message) {
        this.message = message;
        return this;
    }

    public GHFileBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public Github getGithub() {
        return this.github;
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    public GHBranch getBranch() {
        return this.branch;
    }

    public String getContent() {
        return this.content;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPath() {
        return this.path;
    }

    public void commit(String email, String name) {
        String url = this.repository.getUrl() + "/contents/" + this.path;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", this.message);
        JSONObject committer = new JSONObject();
        committer.put("name", name);
        committer.put("email", email);
        jsonObject.put("committer", committer);
        String encodedString = Base64.getEncoder().encodeToString(this.content.getBytes());
        jsonObject.put("content", encodedString);
        if (this.sha != null) {
            jsonObject.put("sha", this.sha);
        }
        this.sendPutRequest(url, this.github.getToken(), jsonObject);
    }

    public void commit() {
        String response = this.sendGetRequest(GHFileBuilder.getBaseUrl() + "/user/email", this.github.getToken());
        if (response == null) {
            response = new JSONObject().put("email", "example@example.com").toString();
        }
        JSONObject jsonObject = new JSONObject(response);
        this.commit(jsonObject.getString("email"), this.github.getSelfUser().getLogin());
    }

    public String getSha() {
        return this.sha;
    }
}

