/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.entities.GHUser;
import io.github.coho04.githubapi.entities.repositories.GHRepository;
import java.time.OffsetDateTime;
import org.json.JSONObject;

public class GHAlert
extends GHBase {
    private final Github github;
    private final int number;
    private final OffsetDateTime createdAt;
    private final String url;
    private final String htmlUrl;
    private final String locationsUrl;
    private final String state;
    private final String resolution;
    private final OffsetDateTime resolvedAt;
    private GHUser resolvedBy;
    private final String secretType;
    private final String secretTypeDisplayName;
    private final String secret;
    private GHRepository repository;
    private GHUser pushProtectionBypassedBy;
    private final boolean pushProtectionBypassed;
    private final OffsetDateTime pushProtectionBypassedAt;
    private final String resolutionComment;
    private final String validity;

    public GHAlert(JSONObject jsonObject, Github github) {
        this.github = github;
        this.number = this.getIntOrNull(jsonObject, "number");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.url = this.getStringOrNull(jsonObject, "url");
        this.htmlUrl = this.getStringOrNull(jsonObject, "html_url");
        this.locationsUrl = this.getStringOrNull(jsonObject, "locations_url");
        this.state = this.getStringOrNull(jsonObject, "state");
        this.resolution = this.getStringOrNull(jsonObject, "resolution");
        this.resolvedAt = this.getLocalDateOrNull(jsonObject, "resolved_at");
        if (jsonObject.has("resolved_by") && !jsonObject.isNull("resolved_by")) {
            this.resolvedBy = new GHUser(github, jsonObject.getJSONObject("resolved_by"));
        }
        this.secretType = this.getStringOrNull(jsonObject, "secret_type");
        this.secretTypeDisplayName = this.getStringOrNull(jsonObject, "secret_type_display_name");
        this.secret = this.getStringOrNull(jsonObject, "secret");
        if (jsonObject.has("repository") && !jsonObject.isNull("repository")) {
            this.repository = new GHRepository(jsonObject.getJSONObject("repository"), github);
        }
        if (jsonObject.has("push_protection_bypassed_by") && !jsonObject.isNull("push_protection_bypassed_by")) {
            this.pushProtectionBypassedBy = new GHUser(github, jsonObject.getJSONObject("push_protection_bypassed_by"));
        }
        this.pushProtectionBypassed = this.getBooleanOrNull(jsonObject, "push_protection_bypassed");
        this.pushProtectionBypassedAt = this.getLocalDateOrNull(jsonObject, "push_protection_bypassed_at");
        this.resolutionComment = this.getStringOrNull(jsonObject, "resolution_comment");
        this.validity = this.getStringOrNull(jsonObject, "validity");
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public int getNumber() {
        return this.number;
    }

    public String getState() {
        return this.state;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    public GHUser getPushProtectionBypassedBy() {
        return this.pushProtectionBypassedBy;
    }

    public GHUser getResolvedBy() {
        return this.resolvedBy;
    }

    public Github getGithub() {
        return this.github;
    }

    public OffsetDateTime getPushProtectionBypassedAt() {
        return this.pushProtectionBypassedAt;
    }

    public OffsetDateTime getResolvedAt() {
        return this.resolvedAt;
    }

    public String getLocationsUrl() {
        return this.locationsUrl;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getResolutionComment() {
        return this.resolutionComment;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getSecretType() {
        return this.secretType;
    }

    public String getSecretTypeDisplayName() {
        return this.secretTypeDisplayName;
    }

    public String getValidity() {
        return this.validity;
    }

    public boolean isPushProtectionBypassed() {
        return this.pushProtectionBypassed;
    }
}

