/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.EntityBase;
import io.github.coho04.githubapi.builders.GHHookBuilder;
import io.github.coho04.githubapi.builders.GHProjectBuilder;
import io.github.coho04.githubapi.builders.GHTeamBuilder;
import io.github.coho04.githubapi.entities.GHAlert;
import io.github.coho04.githubapi.entities.GHEvent;
import io.github.coho04.githubapi.entities.GHHook;
import io.github.coho04.githubapi.entities.GHPackage;
import io.github.coho04.githubapi.entities.GHPlan;
import io.github.coho04.githubapi.entities.GHProject;
import io.github.coho04.githubapi.entities.GHPublicKey;
import io.github.coho04.githubapi.entities.GHRepositoryCache;
import io.github.coho04.githubapi.entities.GHSecret;
import io.github.coho04.githubapi.entities.GHTeam;
import io.github.coho04.githubapi.entities.GHUser;
import io.github.coho04.githubapi.entities.GHVariable;
import io.github.coho04.githubapi.entities.repositories.GHRepository;
import io.github.coho04.githubapi.enums.GHPackageType;
import io.github.coho04.githubapi.enums.GHRole;
import io.github.coho04.githubapi.enums.GHState;
import io.github.coho04.githubapi.utilities.HttpRequestHelper;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class GHOrganisation
extends EntityBase {
    private final Github github;
    private GHPlan plan;
    private final String name;
    private final String hooksUrl;
    private final String issuesUrl;
    private final String membersUrl;
    private final String description;
    private final String givenName;
    private final String company;
    private final String blog;
    private final String location;
    private final String email;
    private final String publicMembersUrl;
    private final String twitterUsername;
    private final boolean isVerified;
    private final boolean hasOrganizationProjects;
    private final boolean hasRepositoryProjects;
    private final int publicRepos;
    private final int publicGists;
    private final int followers;
    private final int following;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime archivedAt;
    private final int totalPrivateRepos;
    private final int ownedPrivateRepos;
    private final int privateGists;
    private final long diskUsage;
    private final int collaborators;
    private final String billingEmail;
    private final String defaultRepositoryPermission;
    private final boolean membersCanCreateRepositories;
    private final boolean twoFactorRequirementEnabled;
    private final String membersAllowedRepositoryCreationType;
    private final boolean membersCanCreatePublicRepositories;
    private final boolean membersCanCreatePrivateRepositories;
    private final boolean membersCanCreateInternalRepositories;
    private final boolean membersCanCreatePages;
    private final boolean membersCanForkPrivateRepositories;
    private final boolean webCommitSignoffRequired;
    private final boolean membersCanCreatePublicPages;
    private final boolean membersCanCreatePrivatePages;
    private final boolean advancedSecurityEnabledForNewRepositories;
    private final boolean dependabotAlertsEnabledForNewRepositories;
    private final boolean dependabotSecurityUpdatesEnabledForNewRepositories;
    private final boolean dependencyGraphEnabledForNewRepositories;
    private final boolean secretScanningEnabledForNewRepositories;
    private final boolean secretScanningPushProtectionEnabledForNewRepositories;
    private final boolean secretScanningPushProtectionCustomLinkEnabled;
    private final String secretScanningPushProtectionCustomLink;
    private final boolean secretScanningValidityChecksEnabled;

    public GHOrganisation(Github github, JSONObject jsonObject, String name) {
        super(jsonObject);
        this.github = github;
        this.givenName = name;
        this.hooksUrl = this.getStringOrNull(jsonObject, "hooks_url");
        this.issuesUrl = this.getStringOrNull(jsonObject, "issues_url");
        this.membersUrl = this.getStringOrNull(jsonObject, "members_url");
        this.publicMembersUrl = this.getStringOrNull(jsonObject, "public_members_url");
        this.description = this.getStringOrNull(jsonObject, "description");
        this.name = this.getStringOrNull(jsonObject, "name");
        this.company = this.getStringOrNull(jsonObject, "company");
        this.blog = this.getStringOrNull(jsonObject, "blog");
        this.location = this.getStringOrNull(jsonObject, "location");
        this.email = this.getStringOrNull(jsonObject, "email");
        this.twitterUsername = this.getStringOrNull(jsonObject, "twitter_username");
        this.isVerified = this.getBooleanOrNull(jsonObject, "is_verified");
        this.hasOrganizationProjects = this.getBooleanOrNull(jsonObject, "has_organization_projects");
        this.hasRepositoryProjects = this.getBooleanOrNull(jsonObject, "has_repository_projects");
        this.publicRepos = this.getIntOrNull(jsonObject, "public_repos");
        this.publicGists = this.getIntOrNull(jsonObject, "public_gists");
        this.followers = this.getIntOrNull(jsonObject, "followers");
        this.following = this.getIntOrNull(jsonObject, "following");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.archivedAt = this.getLocalDateOrNull(jsonObject, "archived_at");
        this.totalPrivateRepos = this.getIntOrNull(jsonObject, "total_private_repos");
        this.ownedPrivateRepos = this.getIntOrNull(jsonObject, "owned_private_repos");
        this.privateGists = this.getIntOrNull(jsonObject, "private_gists");
        this.diskUsage = this.getIntOrNull(jsonObject, "disk_usage").intValue();
        this.collaborators = this.getIntOrNull(jsonObject, "collaborators");
        this.billingEmail = this.getStringOrNull(jsonObject, "billing_email");
        this.defaultRepositoryPermission = this.getStringOrNull(jsonObject, "default_repository_permission");
        this.membersCanCreateRepositories = this.getBooleanOrNull(jsonObject, "members_can_create_repositories");
        this.twoFactorRequirementEnabled = this.getBooleanOrNull(jsonObject, "two_factor_requirement_enabled");
        this.membersAllowedRepositoryCreationType = this.getStringOrNull(jsonObject, "members_allowed_repository_creation_type");
        this.membersCanCreatePublicRepositories = this.getBooleanOrNull(jsonObject, "members_can_create_public_repositories");
        this.membersCanCreatePrivateRepositories = this.getBooleanOrNull(jsonObject, "members_can_create_private_repositories");
        this.membersCanCreateInternalRepositories = this.getBooleanOrNull(jsonObject, "members_can_create_internal_repositories");
        this.membersCanCreatePages = this.getBooleanOrNull(jsonObject, "members_can_create_pages");
        this.membersCanForkPrivateRepositories = this.getBooleanOrNull(jsonObject, "members_can_fork_private_repositories");
        this.webCommitSignoffRequired = this.getBooleanOrNull(jsonObject, "web_commit_signoff_required");
        this.membersCanCreatePublicPages = this.getBooleanOrNull(jsonObject, "members_can_create_public_pages");
        this.membersCanCreatePrivatePages = this.getBooleanOrNull(jsonObject, "members_can_create_private_pages");
        if (jsonObject.has("plan") && !jsonObject.isNull("plan")) {
            this.plan = new GHPlan(jsonObject.getJSONObject("plan"));
        }
        this.advancedSecurityEnabledForNewRepositories = this.getBooleanOrNull(jsonObject, "advanced_security_enabled_for_new_repositories");
        this.dependabotAlertsEnabledForNewRepositories = this.getBooleanOrNull(jsonObject, "dependabot_alerts_enabled_for_new_repositories");
        this.dependabotSecurityUpdatesEnabledForNewRepositories = this.getBooleanOrNull(jsonObject, "dependabot_security_updates_enabled_for_new_repositories");
        this.dependencyGraphEnabledForNewRepositories = this.getBooleanOrNull(jsonObject, "dependency_graph_enabled_for_new_repositories");
        this.secretScanningEnabledForNewRepositories = this.getBooleanOrNull(jsonObject, "secret_scanning_enabled_for_new_repositories");
        this.secretScanningPushProtectionEnabledForNewRepositories = this.getBooleanOrNull(jsonObject, "secret_scanning_push_protection_enabled_for_new_repositories");
        this.secretScanningPushProtectionCustomLinkEnabled = this.getBooleanOrNull(jsonObject, "secret_scanning_push_protection_custom_link_enabled");
        this.secretScanningPushProtectionCustomLink = this.getStringOrNull(jsonObject, "secret_scanning_push_protection_custom_link");
        this.secretScanningValidityChecksEnabled = this.getBooleanOrNull(jsonObject, "secret_scanning_validity_checks_enabled");
    }

    public static GHOrganisation getOrganisation(Github github, String name) {
        String response = HttpRequestHelper.sendGetRequest(GHOrganisation.getBaseUrl() + "/orgs/" + name, github.getToken());
        assert (response != null);
        return new GHOrganisation(github, new JSONObject(response), name);
    }

    public GHRepository findRepositoryByName(String name) {
        String url = GHOrganisation.getBaseUrl() + "/repos/" + this.givenName + "/" + name;
        return new GHRepository(new JSONObject(this.sendGetRequest(url, this.github.getToken())), this.github);
    }

    public List<GHRepository> getRepositories() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/repos", json -> new GHRepository((JSONObject)json, this.github), this.github.getToken());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Github getGithub() {
        return this.github;
    }

    public String getCompany() {
        return this.company;
    }

    public String getHooksUrl() {
        return this.hooksUrl;
    }

    public String getIssuesUrl() {
        return this.issuesUrl;
    }

    public String getMembersUrl() {
        return this.membersUrl;
    }

    public String getPublicMembersUrl() {
        return this.publicMembersUrl;
    }

    public int getFollowers() {
        return this.followers;
    }

    public String getBlog() {
        return this.blog;
    }

    public int getFollowing() {
        return this.following;
    }

    public int getPublicGists() {
        return this.publicGists;
    }

    public int getPublicRepos() {
        return this.publicRepos;
    }

    public String getEmail() {
        return this.email;
    }

    public OffsetDateTime getArchivedAt() {
        return this.archivedAt;
    }

    public String getLocation() {
        return this.location;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getTwitterUsername() {
        return this.twitterUsername;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean isHasOrganizationProjects() {
        return this.hasOrganizationProjects;
    }

    public boolean isHasRepositoryProjects() {
        return this.hasRepositoryProjects;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public GHPlan getPlan() {
        return this.plan;
    }

    public int getCollaborators() {
        return this.collaborators;
    }

    public int getOwnedPrivateRepos() {
        return this.ownedPrivateRepos;
    }

    public int getPrivateGists() {
        return this.privateGists;
    }

    public int getTotalPrivateRepos() {
        return this.totalPrivateRepos;
    }

    public long getDiskUsage() {
        return this.diskUsage;
    }

    public String getBillingEmail() {
        return this.billingEmail;
    }

    public String getDefaultRepositoryPermission() {
        return this.defaultRepositoryPermission;
    }

    public String getMembersAllowedRepositoryCreationType() {
        return this.membersAllowedRepositoryCreationType;
    }

    public String getSecretScanningPushProtectionCustomLink() {
        return this.secretScanningPushProtectionCustomLink;
    }

    public boolean isAdvancedSecurityEnabledForNewRepositories() {
        return this.advancedSecurityEnabledForNewRepositories;
    }

    public boolean isDependabotAlertsEnabledForNewRepositories() {
        return this.dependabotAlertsEnabledForNewRepositories;
    }

    public boolean isDependabotSecurityUpdatesEnabledForNewRepositories() {
        return this.dependabotSecurityUpdatesEnabledForNewRepositories;
    }

    public boolean isDependencyGraphEnabledForNewRepositories() {
        return this.dependencyGraphEnabledForNewRepositories;
    }

    public boolean isMembersCanCreateInternalRepositories() {
        return this.membersCanCreateInternalRepositories;
    }

    public boolean isMembersCanCreatePages() {
        return this.membersCanCreatePages;
    }

    public boolean isMembersCanCreatePrivatePages() {
        return this.membersCanCreatePrivatePages;
    }

    public boolean isMembersCanCreatePrivateRepositories() {
        return this.membersCanCreatePrivateRepositories;
    }

    public boolean isMembersCanCreatePublicPages() {
        return this.membersCanCreatePublicPages;
    }

    public boolean isMembersCanCreatePublicRepositories() {
        return this.membersCanCreatePublicRepositories;
    }

    public boolean isMembersCanCreateRepositories() {
        return this.membersCanCreateRepositories;
    }

    public boolean isMembersCanForkPrivateRepositories() {
        return this.membersCanForkPrivateRepositories;
    }

    public boolean isSecretScanningEnabledForNewRepositories() {
        return this.secretScanningEnabledForNewRepositories;
    }

    public boolean isSecretScanningPushProtectionCustomLinkEnabled() {
        return this.secretScanningPushProtectionCustomLinkEnabled;
    }

    public boolean isSecretScanningPushProtectionEnabledForNewRepositories() {
        return this.secretScanningPushProtectionEnabledForNewRepositories;
    }

    public boolean isSecretScanningValidityChecksEnabled() {
        return this.secretScanningValidityChecksEnabled;
    }

    public boolean isTwoFactorRequirementEnabled() {
        return this.twoFactorRequirementEnabled;
    }

    public boolean isWebCommitSignoffRequired() {
        return this.webCommitSignoffRequired;
    }

    public String getGivenName() {
        return this.givenName.replace(" ", "-");
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("plan", this.plan.toJSONObject()).put("name", this.name).put("description", this.description).put("company", this.company).put("blog", this.blog).put("location", this.location).put("email", this.email).put("hooks_url", this.hooksUrl).put("members_url", this.membersUrl).put("issues_url", this.issuesUrl).put("public_members_url", this.publicMembersUrl).put("twitter_username", this.twitterUsername).put("is_verified", this.isVerified).put("has_organization_projects", this.hasOrganizationProjects).put("has_repository_projects", this.hasRepositoryProjects).put("public_repos", this.publicRepos).put("public_gists", this.publicGists).put("followers", this.followers).put("following", this.following).put("created_at", this.createdAt).put("updated_at", this.updatedAt).put("archived_at", this.archivedAt).put("total_private_repos", this.totalPrivateRepos).put("owned_private_repos", this.ownedPrivateRepos).put("private_gists", this.privateGists).put("disk_usage", this.diskUsage).put("collaborators", this.collaborators).put("billing_email", this.billingEmail).put("default_repository_permission", this.defaultRepositoryPermission).put("members_can_create_repositories", this.membersCanCreateRepositories).put("two_factor_requirement_enabled", this.twoFactorRequirementEnabled).put("members_allowed_repository_creation_type", this.membersAllowedRepositoryCreationType).put("members_can_create_public_repositories", this.membersCanCreatePublicRepositories).put("members_can_create_private_repositories", this.membersCanCreatePrivateRepositories).put("members_can_create_internal_repositories", this.membersCanCreateInternalRepositories).put("members_can_create_pages", this.membersCanCreatePages).put("members_can_fork_private_repositories", this.membersCanForkPrivateRepositories).put("web_commit_signoff_required", this.webCommitSignoffRequired).put("members_can_create_public_pages", this.membersCanCreatePublicPages).put("members_can_create_private_pages", this.membersCanCreatePrivatePages).put("advanced_security_enabled_for_new_repositories", this.advancedSecurityEnabledForNewRepositories).put("dependabot_alerts_enabled_for_new_repositories", this.dependabotAlertsEnabledForNewRepositories).put("dependabot_security_updates_enabled_for_new_repositories", this.dependabotSecurityUpdatesEnabledForNewRepositories).put("dependency_graph_enabled_for_new_repositories", this.dependencyGraphEnabledForNewRepositories).put("secret_scanning_enabled_for_new_repositories", this.secretScanningEnabledForNewRepositories).put("secret_scanning_push_protection_enabled_for_new_repositories", this.secretScanningPushProtectionEnabledForNewRepositories).put("secret_scanning_push_protection_custom_link_enabled", this.secretScanningPushProtectionCustomLinkEnabled).put("secret_scanning_push_protection_custom_link", this.secretScanningPushProtectionCustomLink).put("secret_scanning_validity_checks_enabled", this.secretScanningValidityChecksEnabled);
    }

    public List<GHTeam> getTeams() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/teams", GHTeam::new, this.github.getToken());
    }

    public List<GHTeam> listTeams() {
        return this.getTeams();
    }

    public GHTeam findTeamByName(String name) {
        return GHTeam.getTeamByName(this.github, name, this);
    }

    public GHTeam findTeamBySlug(String slug) {
        return GHTeam.getTeamByName(this.github, slug, this);
    }

    public Boolean hasMember(@NotNull GHUser user) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/members/" + user.getLogin();
        return this.sendGetRequestWithResponseCode(url, this.github.getToken(), 204);
    }

    public void addMember(String email, @NotNull GHRole role, List<Integer> teamIds) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/invitations";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("email", email);
        jsonObject.put("role", role.toString());
        jsonObject.put("team_ids", teamIds);
        HttpRequestHelper.sendPostRequest(url, this.github.getToken(), jsonObject);
    }

    public void removeMember(@NotNull GHUser user) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/members/" + user.getLogin();
        HttpRequestHelper.sendDeleteRequest(url, this.github.getToken());
    }

    public Boolean hasPublicMember(GHUser user) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/public_members/" + user.getLogin();
        return this.sendGetRequestWithResponseCode(url, this.github.getToken(), 204);
    }

    public List<GHUser> listMembers() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/members", jsonObject -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHUser> listPublicMembers() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/public_members", jsonObject -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHUser> listOutsideCollaborators() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/outside_collaborators", jsonObject -> new GHUser(this.github, (JSONObject)jsonObject), this.github.getToken());
    }

    public List<GHProject> listProjects() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/projects", json -> new GHProject(this.github, (JSONObject)json), this.github.getToken());
    }

    public GHProjectBuilder createProject() {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects");
    }

    public GHProject createProject(String name, String body) {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects").setName(name).setBody(body).build();
    }

    public GHTeam createTeam(String name) {
        return new GHTeamBuilder(this.github, this.getUrl() + "/teams").setName(name).build();
    }

    public GHTeamBuilder createTeam() {
        return new GHTeamBuilder(this.github, this.getUrl() + "/teams");
    }

    public List<GHRepository> getRepositorysWithOpenPullRequests() {
        return this.getRepositories().stream().filter(repo -> repo.hasPullRequestsWithState(GHState.OPEN)).toList();
    }

    public List<GHRepository> getPullRequests() {
        return this.getRepositorysWithOpenPullRequests();
    }

    public List<GHEvent> listEvents() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/events", GHEvent::new, this.github.getToken());
    }

    public List<GHHook> getHooks() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/hooks", GHHook::new, this.github.getToken());
    }

    public GHHook getHook(Long id) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/hooks/" + id;
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new GHHook(new JSONObject(response));
    }

    public GHHook getHook(int id) {
        return this.getHook(Integer.toUnsignedLong(id));
    }

    public GHHookBuilder createHook() {
        return new GHHookBuilder(this.github, this.getUrl() + "/hooks");
    }

    public void deleteHook(Long id) {
        this.sendDeleteRequest(this.getUrl() + "/hooks/" + id, this.github.getToken());
    }

    public List<GHPackage> listDockerConflictsPackages() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/docker/conflicts", json -> new GHPackage(this.github, (JSONObject)json), this.github.getToken());
    }

    public List<GHPackage> listPackages(GHPackageType packageType) {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/packages?package_type=" + packageType.toURL(), json -> new GHPackage(this.github, (JSONObject)json), this.github.getToken());
    }

    public GHPackage getPackage(String name, GHPackageType packageType) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/packages/" + packageType.toURL() + name;
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new GHPackage(this.github, new JSONObject(response));
    }

    public List<GHAlert> listSecretScanningAlerts() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/secret-scanning/alerts", json -> new GHAlert((JSONObject)json, this.github), this.github.getToken());
    }

    public int getCacheUsageActiveCount() {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/cache/usage";
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new JSONObject(response).getInt("total_active_caches_count");
    }

    public int getCacheUsageSizeInBytes() {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/cache/usage";
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new JSONObject(response).getInt("total_active_caches_size_in_bytes");
    }

    public List<GHRepositoryCache> listRepositoryCaches() {
        return this.fetchPaginatedData("/orgs/" + this.givenName + "/actions/actions/cache/usage-by-repository", GHRepositoryCache::new, this.github.getToken());
    }

    public List<GHSecret> listSecrets() {
        return this.fetchArrayData("/orgs/" + this.givenName + "/actions/secrets", GHSecret::new, this.github.getToken(), "secrets");
    }

    public GHPublicKey getPublicKey() {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/secrets/public-key";
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new GHPublicKey(new JSONObject(response));
    }

    public GHSecret getSecret(String name) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/secrets/" + name;
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new GHSecret(new JSONObject(response));
    }

    public boolean deleteSecret(String name) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/secrets/" + name;
        return this.sendDeleteRequestWithResponseCode(url, this.github.getToken(), 204);
    }

    public List<GHRepository> listSecretRepositorys() {
        return this.fetchArrayData("/orgs/" + this.givenName + "/actions/secrets", jsonObject -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken(), "repositories");
    }

    public boolean deleteRepositoryFromSecret(String secretName, String repoId) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/secrets/" + secretName + "/repositories/" + repoId;
        return this.sendDeleteRequestWithResponseCode(url, this.github.getToken(), 204);
    }

    public List<GHVariable> listVariables() {
        return this.fetchArrayData("/orgs/" + this.givenName + "/actions/variables", GHVariable::new, this.github.getToken(), "variables");
    }

    public GHVariable getVariable(String name) {
        String url = GHOrganisation.getBaseUrl() + "/orgs/" + this.givenName + "/actions/variables/" + name;
        String response = this.sendGetRequest(url, this.github.getToken());
        assert (response != null);
        return new GHVariable(new JSONObject(response));
    }

    public List<GHRepository> listVariableRepositorys(String name) {
        return this.fetchArrayData("/orgs/" + this.givenName + "/actions/variables/" + name, jsonObject -> new GHRepository((JSONObject)jsonObject, this.github), this.github.getToken(), "repositories");
    }
}

