/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.ClassBase;
import io.github.coho04.githubapi.entities.GHUser;
import org.json.JSONObject;

public class GHPackage
extends ClassBase {
    private final String name;
    private final String packageType;
    private GHUser owner;
    private final String versionCount;
    private final String visibility;
    private final String createdAt;
    private final String updatedAt;

    public GHPackage(Github github, JSONObject jsonObject) {
        super(jsonObject);
        this.name = this.getStringOrNull(jsonObject, "name");
        this.packageType = this.getStringOrNull(jsonObject, "package_type");
        if (jsonObject.has("owner") && !jsonObject.isNull("owner")) {
            this.owner = new GHUser(github, jsonObject.getJSONObject("owner"));
        }
        this.versionCount = this.getStringOrNull(jsonObject, "version_count");
        this.visibility = this.getStringOrNull(jsonObject, "visibility");
        this.createdAt = this.getStringOrNull(jsonObject, "created_at");
        this.updatedAt = this.getStringOrNull(jsonObject, "updated_at");
    }

    public String getName() {
        return this.name;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public GHUser getOwner() {
        return this.owner;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getVersionCount() {
        return this.versionCount;
    }

    public String getVisibility() {
        return this.visibility;
    }
}

