/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.ClassBase;
import io.github.coho04.githubapi.entities.GHOrganisation;
import io.github.coho04.githubapi.utilities.HttpRequestHelper;
import java.time.OffsetDateTime;
import org.json.JSONObject;

public class GHTeam
extends ClassBase {
    private final String name;
    private final String slug;
    private final String description;
    private final String privacy;
    private final String notificationSetting;
    private final String permission;
    private final String membersUrl;
    private final String repositoriesUrl;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final int membersCount;
    private final int reposCount;
    private GHTeam parent;

    public GHTeam(JSONObject jsonObject) {
        super(jsonObject);
        this.name = this.getStringOrNull(jsonObject, "name");
        this.slug = this.getStringOrNull(jsonObject, "slug");
        this.description = this.getStringOrNull(jsonObject, "description");
        this.privacy = this.getStringOrNull(jsonObject, "privacy");
        this.notificationSetting = this.getStringOrNull(jsonObject, "notification_setting");
        this.permission = this.getStringOrNull(jsonObject, "permission");
        this.membersUrl = this.getStringOrNull(jsonObject, "members_url");
        this.repositoriesUrl = this.getStringOrNull(jsonObject, "repositories_url");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.membersCount = this.getIntOrNull(jsonObject, "members_count");
        this.reposCount = this.getIntOrNull(jsonObject, "repos_count");
        JSONObject parentJSONObject = this.getJSONObjectOrNull(jsonObject, "parent");
        if (parentJSONObject != null) {
            this.parent = new GHTeam(parentJSONObject);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        return super.toJSONObject().put("name", this.name).put("slug", this.slug).put("description", this.description).put("privacy", this.privacy).put("notification_setting", this.notificationSetting).put("permission", this.permission).put("members_url", this.membersUrl).put("repositories_url", this.repositoriesUrl).put("created_at", this.createdAt.toString()).put("updated_at", this.updatedAt.toString()).put("members_count", this.membersCount).put("repos_count", this.reposCount).put("parent", this.parent == null ? JSONObject.NULL : this.parent.toJSONObject());
    }

    public static GHTeam getTeamByName(Github github, String name, GHOrganisation organisation) {
        String response = HttpRequestHelper.sendGetRequest(GHTeam.getBaseUrl() + "/orgs/" + organisation.getGivenName() + "/teams/" + name.replace(" ", "-"), github.getToken());
        assert (response != null);
        return new GHTeam(new JSONObject(response));
    }

    public String getDescription() {
        return this.description;
    }

    public String getMembersUrl() {
        return this.membersUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getNotificationSetting() {
        return this.notificationSetting;
    }

    public GHTeam getParent() {
        return this.parent;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getPrivacy() {
        return this.privacy;
    }

    public String getRepositoriesUrl() {
        return this.repositoriesUrl;
    }

    public String getSlug() {
        return this.slug;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public int getMembersCount() {
        return this.membersCount;
    }

    public int getReposCount() {
        return this.reposCount;
    }
}

