/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities;

import io.github.coho04.githubapi.bases.ClassBase;
import io.github.coho04.githubapi.entities.GHStep;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GHWorkflowJob
extends ClassBase {
    private final int runId;
    private final String runUrl;
    private final String headSha;
    private final String status;
    private final String conclusion;
    private final OffsetDateTime startedAt;
    private final OffsetDateTime completedAt;
    private final String name;
    private final List<GHStep> steps = new ArrayList<GHStep>();
    private final String checkRunUrl;
    private List<String> labels;
    private final int runnerId;
    private final String runnerName;
    private final int runnerGroupId;
    private final String runnerGroupName;
    private final String workflowName;
    private final String headBranch;

    public GHWorkflowJob(JSONObject jsonObject) {
        super(jsonObject);
        this.runId = this.getIntOrNull(jsonObject, "run_id");
        this.runUrl = this.getStringOrNull(jsonObject, "run_url");
        this.headSha = this.getStringOrNull(jsonObject, "head_sha");
        this.status = this.getStringOrNull(jsonObject, "status");
        this.conclusion = this.getStringOrNull(jsonObject, "conclusion");
        this.startedAt = this.getLocalDateOrNull(jsonObject, "started_at");
        this.completedAt = this.getLocalDateOrNull(jsonObject, "completed_at");
        this.name = this.getStringOrNull(jsonObject, "name");
        if (jsonObject.has("steps")) {
            JSONArray stepsArray = jsonObject.getJSONArray("steps");
            for (int i = 0; i < stepsArray.length(); ++i) {
                this.steps.add(new GHStep(stepsArray.getJSONObject(i)));
            }
        }
        this.checkRunUrl = this.getStringOrNull(jsonObject, "check_run_url");
        if (jsonObject.has("labels")) {
            this.labels = this.getJSONArrayToStringList(jsonObject, "labels");
        }
        this.runnerId = this.getIntOrNull(jsonObject, "runner_id");
        this.runnerName = this.getStringOrNull(jsonObject, "runner_name");
        this.runnerGroupId = this.getIntOrNull(jsonObject, "runner_group_id");
        this.runnerGroupName = this.getStringOrNull(jsonObject, "runner_group_name");
        this.workflowName = this.getStringOrNull(jsonObject, "workflow_name");
        this.headBranch = this.getStringOrNull(jsonObject, "head_branch");
    }

    public String getName() {
        return this.name;
    }

    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public String getStatus() {
        return this.status;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public int getRunId() {
        return this.runId;
    }

    public int getRunnerGroupId() {
        return this.runnerGroupId;
    }

    public List<GHStep> getSteps() {
        return this.steps;
    }

    public int getRunnerId() {
        return this.runnerId;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getCheckRunUrl() {
        return this.checkRunUrl;
    }

    public String getRunnerGroupName() {
        return this.runnerGroupName;
    }

    public String getRunnerName() {
        return this.runnerName;
    }

    public String getRunUrl() {
        return this.runUrl;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }
}

