/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities.repositories;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.GHBase;
import io.github.coho04.githubapi.builders.GHFileBuilder;
import io.github.coho04.githubapi.entities.repositories.GHRepository;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.json.JSONObject;

public class GHFile
extends GHBase {
    private final Github github;
    private final GHRepository repository;
    private final String name;
    private final String path;
    private final String sha;
    private final int size;
    private final String url;
    private final String htmlUrl;
    private final String gitUrl;
    private final String downloadUrl;
    private final String type;
    private String content;

    public GHFile(Github github, JSONObject jsonObject, GHRepository repository) {
        String encodedContent;
        this.github = github;
        this.repository = repository;
        this.name = this.getStringOrNull(jsonObject, "name");
        this.path = this.getStringOrNull(jsonObject, "path");
        this.sha = this.getStringOrNull(jsonObject, "sha");
        this.size = this.getIntOrNull(jsonObject, "size");
        this.url = this.getStringOrNull(jsonObject, "url");
        this.htmlUrl = this.getStringOrNull(jsonObject, "html_url");
        this.gitUrl = this.getStringOrNull(jsonObject, "git_url");
        this.downloadUrl = this.getStringOrNull(jsonObject, "download_url");
        this.type = this.getStringOrNull(jsonObject, "type");
        if (jsonObject.has("content") && (encodedContent = this.getStringOrNull(jsonObject, "content")) != null) {
            encodedContent = encodedContent.replaceAll("\\s+", "");
            byte[] decodedBytes = Base64.getDecoder().decode(encodedContent);
            this.content = new String(decodedBytes, StandardCharsets.UTF_8);
        }
    }

    public GHFileBuilder updateFile() {
        return new GHFileBuilder(this.repository, this.github, this.sha);
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public String getPath() {
        return this.path;
    }

    public String getSha() {
        return this.sha;
    }

    public String getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public Github getGithub() {
        return this.github;
    }

    public GHRepository getRepository() {
        return this.repository;
    }
}

