/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities.repositories;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.ClassBase;
import io.github.coho04.githubapi.entities.GHUser;
import io.github.coho04.githubapi.entities.repositories.GHLabel;
import io.github.coho04.githubapi.entities.repositories.GHMilestone;
import io.github.coho04.githubapi.enums.GHState;
import java.time.OffsetDateTime;
import java.util.List;
import org.json.JSONObject;

public class GHIssue
extends ClassBase {
    private final Github github;
    private final int number;
    private final String body;
    private final String title;
    private final GHState state;
    private final int comments;
    private final boolean draft;
    private final boolean locked;
    private final String labelsUrl;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime closedAt;
    private final String commentsUrl;
    private final String timelineUrl;
    private final String repositoryUrl;
    private final String activeLockReason;
    private final String authorAssociation;
    private final String performedViaGithubApp;
    private final String stateReason;
    private GHMilestone milestone;
    private final List<GHLabel> labels;
    private final List<GHUser> assignees;
    private GHUser user;
    private GHUser assignee;

    public GHIssue(Github github, JSONObject jsonObject) {
        super(jsonObject);
        JSONObject assigneeJSONObject;
        this.github = github;
        this.number = this.getIntOrNull(jsonObject, "number");
        this.body = this.getStringOrNull(jsonObject, "body");
        this.title = this.getStringOrNull(jsonObject, "title");
        this.state = GHState.fromString(this.getStringOrNull(jsonObject, "state"));
        this.draft = this.getBooleanOrNull(jsonObject, "draft");
        this.locked = this.getBooleanOrNull(jsonObject, "locked");
        this.labelsUrl = this.getStringOrNull(jsonObject, "labels_url");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.authorAssociation = this.getStringOrNull(jsonObject, "author_association");
        this.commentsUrl = this.getStringOrNull(jsonObject, "comments_url");
        this.activeLockReason = this.getStringOrNull(jsonObject, "active_lock_reason");
        this.repositoryUrl = this.getStringOrNull(jsonObject, "repository_url");
        this.timelineUrl = this.getStringOrNull(jsonObject, "timeline_url");
        this.performedViaGithubApp = this.getStringOrNull(jsonObject, "performed_via_github_app");
        this.stateReason = this.getStringOrNull(jsonObject, "state_reason");
        this.comments = this.getIntOrNull(jsonObject, "comments");
        this.closedAt = this.getLocalDateOrNull(jsonObject, "closed_at");
        if (jsonObject.has("milestone") && !jsonObject.isNull("milestone")) {
            this.milestone = new GHMilestone(github, this.getJSONObjectOrNull(jsonObject, "milestone"));
        }
        this.labels = this.getArrayOrNull(jsonObject, "labels", GHLabel::new);
        this.assignees = this.getArrayOrNull(jsonObject, "assignees", jsonObject1 -> new GHUser(github, jsonObject1));
        if (jsonObject.has("user")) {
            this.user = new GHUser(github, this.getJSONObjectOrNull(jsonObject, "user"));
        }
        if ((assigneeJSONObject = this.getJSONObjectOrNull(jsonObject, "assignee")) != null) {
            this.assignee = new GHUser(github, assigneeJSONObject);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = super.toJSONObject().put("number", this.number).put("body", this.body).put("title", this.title).put("state", this.state.toString()).put("draft", this.draft).put("locked", this.locked).put("labels_url", this.labelsUrl).put("created_at", this.createdAt.toString()).put("updated_at", this.updatedAt.toString()).put("author_association", this.authorAssociation).put("comments_url", this.commentsUrl).put("active_lock_reason", this.activeLockReason).put("repository_url", this.repositoryUrl).put("timeline_url", this.timelineUrl).put("performed_via_github_app", this.performedViaGithubApp).put("state_reason", this.stateReason).put("comments", this.comments).put("labels", this.labels).put("assignees", this.assignees).put("user", this.user.toJSONObject()).put("assignee", this.assignee.toJSONObject());
        if (this.closedAt != null) {
            jsonObject.put("closed_at", this.closedAt.toString());
        }
        if (this.milestone != null) {
            jsonObject.put("milestone", this.milestone.toJSONObject());
        }
        return jsonObject;
    }

    public void close() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", GHState.CLOSED.toString());
        this.sendPatchRequest(this.getUrl(), this.github.getToken(), jsonObject);
    }

    public int getNumber() {
        return this.number;
    }

    public int getComments() {
        return this.comments;
    }

    public String getActiveLockReason() {
        return this.activeLockReason;
    }

    public String getAuthorAssociation() {
        return this.authorAssociation;
    }

    public String getBody() {
        return this.body;
    }

    public OffsetDateTime getClosedAt() {
        return this.closedAt;
    }

    public String getCommentsUrl() {
        return this.commentsUrl;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getLabelsUrl() {
        return this.labelsUrl;
    }

    public GHMilestone getMilestone() {
        return this.milestone;
    }

    public String getPerformedViaGithubApp() {
        return this.performedViaGithubApp;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public GHState getState() {
        return this.state;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public String getTimelineUrl() {
        return this.timelineUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public GHUser getUser() {
        return this.user;
    }

    public GHUser getAssignee() {
        return this.assignee;
    }

    public List<GHLabel> getLabels() {
        return this.labels;
    }

    public List<GHUser> getAssignees() {
        return this.assignees;
    }
}

