/*
 * Decompiled with CFR 0.152.
 */
package io.github.coho04.githubapi.entities.repositories;

import io.github.coho04.githubapi.Github;
import io.github.coho04.githubapi.bases.ClassBase;
import io.github.coho04.githubapi.builders.GHFileBuilder;
import io.github.coho04.githubapi.builders.GHIssueBuilder;
import io.github.coho04.githubapi.builders.GHProjectBuilder;
import io.github.coho04.githubapi.entities.GHActionsCache;
import io.github.coho04.githubapi.entities.GHArtifact;
import io.github.coho04.githubapi.entities.GHEvent;
import io.github.coho04.githubapi.entities.GHPermission;
import io.github.coho04.githubapi.entities.GHProject;
import io.github.coho04.githubapi.entities.GHPublicKey;
import io.github.coho04.githubapi.entities.GHPullRequest;
import io.github.coho04.githubapi.entities.GHRepositoryCache;
import io.github.coho04.githubapi.entities.GHSecret;
import io.github.coho04.githubapi.entities.GHUser;
import io.github.coho04.githubapi.entities.GHVariable;
import io.github.coho04.githubapi.entities.GHWorkflowJob;
import io.github.coho04.githubapi.entities.GHWorkflowRun;
import io.github.coho04.githubapi.entities.repositories.GHBranch;
import io.github.coho04.githubapi.entities.repositories.GHFile;
import io.github.coho04.githubapi.entities.repositories.GHIssue;
import io.github.coho04.githubapi.entities.repositories.GHLicense;
import io.github.coho04.githubapi.enums.GHState;
import io.github.coho04.githubapi.utilities.HttpRequestHelper;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class GHRepository
extends ClassBase {
    private final int size;
    private final int forks;
    private GHLicense license;
    private final String name;
    private final boolean fork;
    private final int watchers;
    private GHUser owner;
    private final String sshUrl;
    private final String svnUrl;
    private final Github github;
    private final String keysUrl;
    private final String tagsUrl;
    private final String cloneUrl;
    private final OffsetDateTime pushedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final String language;
    private final String fullName;
    private final String forksUrl;
    private final String treesUrl;
    private final String pullsUrl;
    private final String hooksUrl;
    private final String labelsUrl;
    private final boolean archived;
    private final boolean isPrivate;
    private final String gitRefsUrl;
    private final String visibility;
    private final String archiveUrl;
    private final String statusesUrl;
    private final boolean isTemplate;
    private final String description;
    private final String branchesUrl;
    private final String releasesUrl;
    private List<String> topics;
    private final String languagesUrl;
    private final int stargazersCount;
    private final int openIssuesCount;
    private final String defaultBranch;
    private final boolean hasDownloads;
    private final boolean allowForking;
    private final String subscribersUrl;
    private final String subscriptionUrl;
    private final String issueCommentUrl;
    private final boolean hasDiscussions;
    private final String contributorsUrl;
    private final String collaboratorsUrl;
    private final boolean hasProjects;
    private final String deploymentsUrl;
    private final boolean hasWiki;
    private final String commentsUrl;
    private final String stargazersUrl;
    private final boolean disabled;
    private final String gitUrl;
    private final boolean hasPages;
    private final String commitsUrl;
    private final String compareUrl;
    private final String gitCommitsUrl;
    private final String blobsUrl;
    private final String gitTagsUrl;
    private final String mergesUrl;
    private final String downloadsUrl;
    private final boolean hasIssues;
    private final String notificationsUrl;
    private final String contentsUrl;
    private final String mirrorUrl;
    private final String milestonesUrl;
    private final String teamsUrl;
    private final String issuesUrl;
    private final String issueEventsUrl;
    private final String assigneesUrl;
    private final int openIssues;
    private final int watchersCount;
    private String homepage;
    private final int forksCount;
    private GHPermission permissions;
    private final boolean webCommitSignoffRequired;

    public GHRepository(JSONObject jsonObject, Github github) {
        super(jsonObject);
        this.github = github;
        this.allowForking = this.getBooleanOrNull(jsonObject, "allow_forking");
        this.stargazersCount = this.getIntOrNull(jsonObject, "stargazers_count");
        this.isTemplate = this.getBooleanOrNull(jsonObject, "is_template");
        this.pushedAt = this.getLocalDateOrNull(jsonObject, "pushed_at");
        this.subscriptionUrl = this.getStringOrNull(jsonObject, "subscription_url");
        this.language = this.getStringOrNull(jsonObject, "language");
        this.branchesUrl = this.getStringOrNull(jsonObject, "branches_url");
        this.issueCommentUrl = this.getStringOrNull(jsonObject, "issue_comment_url");
        this.labelsUrl = this.getStringOrNull(jsonObject, "labels_url");
        this.subscribersUrl = this.getStringOrNull(jsonObject, "subscribers_url");
        this.releasesUrl = this.getStringOrNull(jsonObject, "releases_url");
        this.svnUrl = this.getStringOrNull(jsonObject, "svn_url");
        this.hasDiscussions = this.getBooleanOrNull(jsonObject, "has_discussions");
        this.forks = this.getIntOrNull(jsonObject, "forks");
        this.archiveUrl = this.getStringOrNull(jsonObject, "archive_url");
        this.gitRefsUrl = this.getStringOrNull(jsonObject, "git_refs_url");
        this.forksUrl = this.getStringOrNull(jsonObject, "forks_url");
        this.visibility = this.getStringOrNull(jsonObject, "visibility");
        this.statusesUrl = this.getStringOrNull(jsonObject, "statuses_url");
        this.sshUrl = this.getStringOrNull(jsonObject, "ssh_url");
        this.fullName = this.getStringOrNull(jsonObject, "full_name");
        this.size = this.getIntOrNull(jsonObject, "size");
        this.languagesUrl = this.getStringOrNull(jsonObject, "languages_url");
        this.collaboratorsUrl = this.getStringOrNull(jsonObject, "collaborators_url");
        this.cloneUrl = this.getStringOrNull(jsonObject, "clone_url");
        this.name = this.getStringOrNull(jsonObject, "name");
        this.pullsUrl = this.getStringOrNull(jsonObject, "pulls_url");
        this.defaultBranch = this.getStringOrNull(jsonObject, "default_branch");
        this.hooksUrl = this.getStringOrNull(jsonObject, "hooks_url");
        this.treesUrl = this.getStringOrNull(jsonObject, "trees_url");
        this.tagsUrl = this.getStringOrNull(jsonObject, "tags_url");
        this.gitUrl = this.getStringOrNull(jsonObject, "git_url");
        this.isPrivate = this.getBooleanOrNull(jsonObject, "private");
        this.contributorsUrl = this.getStringOrNull(jsonObject, "contributors_url");
        this.hasDownloads = this.getBooleanOrNull(jsonObject, "has_downloads");
        this.notificationsUrl = this.getStringOrNull(jsonObject, "notifications_url");
        this.openIssuesCount = this.getIntOrNull(jsonObject, "open_issues_count");
        this.description = this.getStringOrNull(jsonObject, "description");
        this.createdAt = this.getLocalDateOrNull(jsonObject, "created_at");
        this.watchers = this.getIntOrNull(jsonObject, "watchers");
        this.keysUrl = this.getStringOrNull(jsonObject, "keys_url");
        this.deploymentsUrl = this.getStringOrNull(jsonObject, "deployments_url");
        this.hasProjects = this.getBooleanOrNull(jsonObject, "has_projects");
        this.archived = this.getBooleanOrNull(jsonObject, "archived");
        this.hasWiki = this.getBooleanOrNull(jsonObject, "has_wiki");
        this.updatedAt = this.getLocalDateOrNull(jsonObject, "updated_at");
        this.commentsUrl = this.getStringOrNull(jsonObject, "comments_url");
        this.disabled = this.getBooleanOrNull(jsonObject, "disabled");
        this.hasPages = this.getBooleanOrNull(jsonObject, "has_pages");
        this.stargazersUrl = this.getStringOrNull(jsonObject, "stargazers_url");
        this.commitsUrl = this.getStringOrNull(jsonObject, "commits_url");
        this.compareUrl = this.getStringOrNull(jsonObject, "compare_url");
        this.gitCommitsUrl = this.getStringOrNull(jsonObject, "git_commits_url");
        this.blobsUrl = this.getStringOrNull(jsonObject, "blobs_url");
        this.gitTagsUrl = this.getStringOrNull(jsonObject, "git_tags_url");
        this.mergesUrl = this.getStringOrNull(jsonObject, "merges_url");
        this.downloadsUrl = this.getStringOrNull(jsonObject, "downloads_url");
        this.hasIssues = this.getBooleanOrNull(jsonObject, "has_issues");
        this.webCommitSignoffRequired = this.getBooleanOrNull(jsonObject, "web_commit_signoff_required");
        this.contentsUrl = this.getStringOrNull(jsonObject, "contents_url");
        this.mirrorUrl = this.getStringOrNull(jsonObject, "mirror_url");
        this.milestonesUrl = this.getStringOrNull(jsonObject, "milestones_url");
        this.teamsUrl = this.getStringOrNull(jsonObject, "teams_url");
        this.fork = this.getBooleanOrNull(jsonObject, "fork");
        this.issuesUrl = this.getStringOrNull(jsonObject, "issues_url");
        this.issueEventsUrl = this.getStringOrNull(jsonObject, "issue_events_url");
        this.assigneesUrl = this.getStringOrNull(jsonObject, "assignees_url");
        this.openIssues = this.getIntOrNull(jsonObject, "open_issues");
        this.watchersCount = this.getIntOrNull(jsonObject, "watchers_count");
        this.homepage = this.getStringOrNull(jsonObject, "homepage");
        this.forksCount = this.getIntOrNull(jsonObject, "forks_count");
        if (jsonObject.has("owner") && !jsonObject.isNull("owner")) {
            this.owner = new GHUser(github, this.getJSONObjectOrNull(jsonObject, "owner"));
        }
        if (jsonObject.has("license") && !jsonObject.isNull("license")) {
            this.license = new GHLicense(this.getJSONObjectOrNull(jsonObject, "license"));
        }
        if (jsonObject.has("permissions")) {
            this.permissions = new GHPermission(this.getJSONObjectOrNull(jsonObject, "permissions"));
        }
        if (jsonObject.has("topics") && !jsonObject.isNull("topics")) {
            this.topics = jsonObject.getJSONArray("topics").toList().stream().map(Object::toString).collect(Collectors.toList());
        }
    }

    public static GHRepository getRepository(Github github, String owner, String name) {
        String response = HttpRequestHelper.sendGetRequest(GHRepository.getBaseUrl() + "/repos/" + owner + "/" + name, github.getToken());
        assert (response != null);
        return new GHRepository(new JSONObject(response), github);
    }

    public GHIssueBuilder createIssue(String title) {
        return new GHIssueBuilder(this.github, this.getUrl(), title);
    }

    public Map<String, GHBranch> getBranches() {
        HashMap<String, GHBranch> branches = new HashMap<String, GHBranch>();
        String response = this.sendGetRequest(this.getUrl() + "/branches", this.github.getToken());
        if (response != null) {
            JSONArray jsonArray = new JSONArray(response);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String name = this.getStringOrNull(jsonObject, "name");
                branches.put(name, new GHBranch(jsonObject));
            }
        }
        return branches;
    }

    public List<GHUser> getContributors() {
        String response = this.sendGetRequest(this.getUrl() + "/contributors", this.github.getToken());
        ArrayList<GHUser> contributors = new ArrayList<GHUser>();
        if (response != null) {
            JSONArray jsonArray = new JSONArray(response);
            for (int i = 0; i < jsonArray.length(); ++i) {
                contributors.add(new GHUser(this.github, jsonArray.getJSONObject(i)));
            }
        }
        return contributors;
    }

    public List<GHIssue> getIssues() {
        String response = this.sendGetRequest(this.getUrl() + "/issues", this.github.getToken());
        ArrayList<GHIssue> issues = new ArrayList<GHIssue>();
        if (response != null) {
            JSONArray jsonArray = new JSONArray(response);
            for (int i = 0; i < jsonArray.length(); ++i) {
                issues.add(new GHIssue(this.github, jsonArray.getJSONObject(i)));
            }
        }
        return issues;
    }

    public GHIssue getIssueById(int id) {
        String response = this.sendGetRequest(this.getUrl() + "/issues/" + id, this.github.getToken());
        if (response != null) {
            return new GHIssue(this.github, new JSONObject(response));
        }
        return null;
    }

    public GHFileBuilder addFile() {
        return new GHFileBuilder(this, this.github);
    }

    public GHFileBuilder addFile(GHBranch branch) {
        return new GHFileBuilder(this, branch, this.github);
    }

    public GHFileBuilder addFile(GHBranch branch, String path, String content, String message) {
        return new GHFileBuilder(this, branch, path, content, message, this.github);
    }

    public List<String> getAllFilenames() {
        ArrayList<String> filenames = new ArrayList<String>();
        Object url = GHRepository.getBaseUrl() + "/repos/" + this.owner.getLogin() + "/" + this.name + "/contents/?per_page=100";
        while (url != null) {
            String[] responseAndLink = this.sendGetRequestWithLinkHeader((String)url, this.github.getToken());
            String response = responseAndLink[0];
            JSONArray json = new JSONArray(response);
            for (int i = 0; i < json.length(); ++i) {
                JSONObject fileJson = json.getJSONObject(i);
                if (!"file".equals(fileJson.getString("type"))) continue;
                filenames.add(fileJson.getString("name"));
            }
            url = this.extractNextPageUrl(responseAndLink[1]);
        }
        return filenames;
    }

    public List<GHFile> getDirectoryContent(String path) {
        ArrayList<GHFile> files = new ArrayList<GHFile>();
        String response = this.sendGetRequest(this.getUrl() + "/contents/" + path, this.github.getToken());
        if (response != null) {
            JSONArray jsonArray = new JSONArray(response);
            for (int i = 0; i < jsonArray.length(); ++i) {
                files.add(new GHFile(this.github, jsonArray.getJSONObject(i), this));
            }
        }
        return files;
    }

    public List<GHFile> getDirectoryContentWithFileContent(String path) {
        ArrayList<GHFile> files = new ArrayList<GHFile>();
        String response = this.sendGetRequest(this.getUrl() + "/contents/" + path, this.github.getToken());
        if (response != null) {
            JSONArray jsonArray = new JSONArray(response);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject.getString("type").equals("file")) {
                    String fileContent = this.sendGetRequest(jsonObject.getString("url"), this.github.getToken());
                    files.add(new GHFile(this.github, new JSONObject(fileContent), this));
                    continue;
                }
                files.add(new GHFile(this.github, jsonArray.getJSONObject(i), this));
            }
        }
        return files;
    }

    public int getForks() {
        return this.forks;
    }

    public int getOpenIssuesCount() {
        return this.openIssuesCount;
    }

    public int getSize() {
        return this.size;
    }

    public int getStargazersCount() {
        return this.stargazersCount;
    }

    public Object getPermissions() {
        return this.permissions;
    }

    public OffsetDateTime getPushedAt() {
        return this.pushedAt;
    }

    public String getBranchesUrl() {
        return this.branchesUrl;
    }

    public String getIssueCommentUrl() {
        return this.issueCommentUrl;
    }

    public String getArchiveUrl() {
        return this.archiveUrl;
    }

    public String getLabelsUrl() {
        return this.labelsUrl;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getReleasesUrl() {
        return this.releasesUrl;
    }

    public String getSubscribersUrl() {
        return this.subscribersUrl;
    }

    public String getSubscriptionUrl() {
        return this.subscriptionUrl;
    }

    public String getForksUrl() {
        return this.forksUrl;
    }

    public String getGitRefsUrl() {
        return this.gitRefsUrl;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public String getSvnUrl() {
        return this.svnUrl;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getBlobsUrl() {
        return this.blobsUrl;
    }

    public String getCloneUrl() {
        return this.cloneUrl;
    }

    public String getCollaboratorsUrl() {
        return this.collaboratorsUrl;
    }

    public String getCommentsUrl() {
        return this.commentsUrl;
    }

    public String getCommitsUrl() {
        return this.commitsUrl;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getCompareUrl() {
        return this.compareUrl;
    }

    public String getContentsUrl() {
        return this.contentsUrl;
    }

    public String getContributorsUrl() {
        return this.contributorsUrl;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public String getDeploymentsUrl() {
        return this.deploymentsUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDownloadsUrl() {
        return this.downloadsUrl;
    }

    public String getStatusesUrl() {
        return this.statusesUrl;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getGitCommitsUrl() {
        return this.gitCommitsUrl;
    }

    public String getLanguagesUrl() {
        return this.languagesUrl;
    }

    public String getGitTagsUrl() {
        return this.gitTagsUrl;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public String getAssigneesUrl() {
        return this.assigneesUrl;
    }

    public int getOpenIssues() {
        return this.openIssues;
    }

    public int getWatchersCount() {
        return this.watchersCount;
    }

    public String getHooksUrl() {
        return this.hooksUrl;
    }

    public String getIssueEventsUrl() {
        return this.issueEventsUrl;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getIssuesUrl() {
        return this.issuesUrl;
    }

    public int getForksCount() {
        return this.forksCount;
    }

    public String getKeysUrl() {
        return this.keysUrl;
    }

    public String getMergesUrl() {
        return this.mergesUrl;
    }

    public String getMilestonesUrl() {
        return this.milestonesUrl;
    }

    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getNotificationsUrl() {
        return this.notificationsUrl;
    }

    public String getPullsUrl() {
        return this.pullsUrl;
    }

    public String getStargazersUrl() {
        return this.stargazersUrl;
    }

    public String getTagsUrl() {
        return this.tagsUrl;
    }

    public String getTeamsUrl() {
        return this.teamsUrl;
    }

    public String getTreesUrl() {
        return this.treesUrl;
    }

    public boolean isWebCommitSignoffRequired() {
        return this.webCommitSignoffRequired;
    }

    public boolean isHasDiscussions() {
        return this.hasDiscussions;
    }

    public boolean isAllowForking() {
        return this.allowForking;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isFork() {
        return this.fork;
    }

    public boolean isHasPages() {
        return this.hasPages;
    }

    public boolean isHasDownloads() {
        return this.hasDownloads;
    }

    public boolean isHasProjects() {
        return this.hasProjects;
    }

    public boolean isHasWiki() {
        return this.hasWiki;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isHasIssues() {
        return this.hasIssues;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public GHLicense getLicense() {
        return this.license;
    }

    public GHUser getOwner() {
        return this.owner;
    }

    public List<GHPullRequest> listPullRequests() {
        String url = "/repos/" + this.getOwner().getLogin() + "/" + this.getName() + "/pulls";
        return this.fetchPaginatedData(url, (JSONObject json) -> new GHPullRequest(this.github, (JSONObject)json), this.github.getToken(), "&state=all");
    }

    public boolean hasPullRequestsWithState(GHState state) {
        return this.listPullRequests().stream().anyMatch(pr -> pr.getState().equals((Object)state));
    }

    public void updateTopics(List<String> topics) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("names", new JSONArray((Collection<?>)topics));
        this.sendPutRequest(this.getUrl() + "/topics", this.github.getToken(), jsonObject);
        this.topics = List.copyOf(topics);
    }

    public void updateHomePage(String homepageUrl) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("homepage", homepageUrl);
        this.sendPatchRequest(this.getUrl(), this.github.getToken(), jsonObject);
        this.homepage = homepageUrl;
    }

    public List<GHEvent> listEvents() {
        return this.fetchPaginatedData(this.getUrl(), "/events", GHEvent::new, this.github.getToken());
    }

    public List<GHArtifact> listArtifacts() {
        return this.fetchPaginatedData(this.getUrl(), "/actions/artifacts", GHArtifact::new, this.github.getToken());
    }

    public GHArtifact getArtifact(int id) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/artifacts/" + id, this.github.getToken());
        return new GHArtifact(new JSONObject(response));
    }

    public Boolean deleteArtifact(int id) {
        return this.sendDeleteRequestWithResponseCode(this.getUrl() + "/actions/artifacts/" + id, this.github.getToken(), 204);
    }

    public GHRepositoryCache getCache() {
        String response = this.sendGetRequest(this.getUrl() + "/actions/cache/usage", this.github.getToken());
        assert (response != null);
        return new GHRepositoryCache(new JSONObject(response));
    }

    public List<GHActionsCache> listActionsCaches() {
        return this.fetchPaginatedData(this.getUrl(), "/actions/artifacts", GHActionsCache::new, this.github.getToken());
    }

    public void deleteActionsCache(String key) {
        this.sendDeleteRequest(this.getUrl() + "/actions/caches?key=" + key, this.github.getToken());
    }

    public boolean deleteActionsCache(int id) {
        return this.sendDeleteRequestWithResponseCode(this.getUrl() + "/actions/caches/" + id, this.github.getToken(), 204);
    }

    public List<GHSecret> listOrganisationSecrets() {
        return this.fetchArrayData(this.getUrl(), "/actions/organization-secrets", GHSecret::new, this.github.getToken(), "secrets");
    }

    public List<GHSecret> listRepositorySecrets() {
        return this.fetchArrayData(this.getUrl(), "/actions/secrets", GHSecret::new, this.github.getToken(), "secrets");
    }

    public GHPublicKey getPublicKey() {
        String response = this.sendGetRequest(this.getUrl() + "/actions/secrets/public-key", this.github.getToken());
        return new GHPublicKey(new JSONObject(response));
    }

    public GHSecret getSecret(String name) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/secrets/" + name, this.github.getToken());
        return new GHSecret(new JSONObject(response));
    }

    public List<GHSecret> listEnvironmentSecrets(String environment) {
        return this.fetchArrayData(this.getUrl(), "/actions/environments/" + environment + "/secrets", GHSecret::new, this.github.getToken(), "secrets");
    }

    public GHPublicKey getEnvironmentPublicKey(String environment) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/environments/" + environment + "/secrets/public-key", this.github.getToken());
        return new GHPublicKey(new JSONObject(response));
    }

    public GHSecret getEnvironmentSecret(String environment, String name) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/environments/" + environment + "/secrets/" + name, this.github.getToken());
        return new GHSecret(new JSONObject(response));
    }

    public List<GHVariable> listOrganisationVariables() {
        return this.fetchArrayData(this.getUrl(), "/actions/organization-variables", GHVariable::new, this.github.getToken(), "secrets");
    }

    public List<GHVariable> listRepositoryVariables() {
        return this.fetchArrayData(this.getUrl(), "/actions/variables", GHVariable::new, this.github.getToken(), "variables");
    }

    public GHVariable getVariable(String name) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/variables/" + name, this.github.getToken());
        return new GHVariable(new JSONObject(response));
    }

    public List<GHVariable> listEnvironmentVariables(String environment) {
        return this.fetchArrayData(this.getUrl(), "/environments/" + environment + "/variables", GHVariable::new, this.github.getToken(), "variables");
    }

    public GHVariable getEnvironmentVariable(String environment, String name) {
        String response = this.sendGetRequest(this.getUrl() + "/environments/" + environment + "/variables/" + name, this.github.getToken());
        return new GHVariable(new JSONObject(response));
    }

    public GHWorkflowJob getJobFromWorkflowRun(int id) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/jobs/" + id, this.github.getToken());
        return new GHWorkflowJob(new JSONObject(response));
    }

    public List<GHWorkflowJob> listJobsFromWorkflowRun(int id) {
        return this.fetchArrayData(this.getUrl(), "/actions/runs/" + id + "/jobs", GHWorkflowJob::new, this.github.getToken(), "jobs");
    }

    public List<GHWorkflowJob> listJobsForWorkflowAttempt(int id, int attempt) {
        return this.fetchArrayData(this.getUrl(), "/actions/runs/" + id + "/attempts/" + attempt + "/jobs", GHWorkflowJob::new, this.github.getToken(), "jobs");
    }

    public GHWorkflowRun getWorkflowRun(int id) {
        String response = this.sendGetRequest(this.getUrl() + "/actions/runs/" + id, this.github.getToken());
        return new GHWorkflowRun(new JSONObject(response));
    }

    public GHProjectBuilder createProject() {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects");
    }

    public GHProject createProject(String name, String body) {
        return new GHProjectBuilder(this.github, this.getUrl() + "/projects").setName(name).setBody(body).build();
    }
}

