/*
 * Decompiled with CFR 0.152.
 */
package com.ctyun;

import com.ctyun.HttpGetWithEntity;
import com.ctyun.common.Response;
import com.ctyun.utils.ConfigUtils;
import com.ctyun.utils.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class AiSDK {
    private String url;
    private String body;
    private String ak;
    private String sk;
    private String uuId;
    private int temp;
    private String appKey;
    Properties p = ConfigUtils.loadConfigs();

    public AiSDK() {
    }

    public AiSDK(String ak, String sk, String appKey, String url, String body) {
        this.url = url;
        this.body = body;
        this.ak = ak;
        this.sk = sk;
        this.uuId = UUID.randomUUID().toString();
        this.temp = Integer.valueOf(this.p.getProperty("temp"));
        this.appKey = appKey;
    }

    public AiSDK(String url, String ak, String sk, String uuId, String body, int temp, String appKey) {
        this.url = url;
        this.body = body;
        this.ak = ak;
        this.sk = sk;
        this.uuId = uuId;
        this.temp = temp;
        this.appKey = appKey;
    }

    public Response CallAPI() {
        Response response = this.CallAPI("post", Integer.parseInt(this.p.getProperty("connectTimeout")), Integer.parseInt(this.p.getProperty("connectionRequestTimeout")), Integer.parseInt(this.p.getProperty("socketTimeout")));
        response.setBody(StringUtils.convertUnicodeToCh(new String(response.getBody().getBytes(StandardCharsets.ISO_8859_1))));
        return response;
    }

    public Response CallAPI(String method, int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        Response response = null;
        switch (method = method.toUpperCase()) {
            case "POST": {
                response = this.doPost(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            }
            case "GET": {
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.body)) {
                    response = this.sendJsonByGetReq(connectTimeout, connectionRequestTimeout, socketTimeout);
                    break;
                }
                response = this.doGet(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            }
            case "DELETE": {
                response = this.doDelete(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            }
            case "PUT": {
                response = this.doPut(connectTimeout, connectionRequestTimeout, socketTimeout);
                break;
            }
            case "HEAD": {
                response = this.doHead(connectTimeout, connectionRequestTimeout, socketTimeout);
            }
        }
        return response;
    }

    private String getSign(Date eopDate) {
        String calculateContentHash = this.getSHA256(this.body);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");
        Date nowdate = new Date();
        String singerDate = TIME_FORMATTER.format(nowdate);
        String singerDd = DATE_FORMATTER.format(nowdate);
        try {
            URL url = new URL(this.url);
            String CampmocalHeader = String.format("appkey:%s\nctyun-eop-request-id:%s\neop-date:%s\n", this.appKey, this.uuId, singerDate);
            String query = url.getQuery();
            String afterQuery = "";
            if (query != null) {
                Object[] param = query.split("&");
                Arrays.sort(param);
                for (Object str : param) {
                    afterQuery = afterQuery.length() < 1 ? afterQuery + (String)str : afterQuery + "&" + (String)str;
                }
            }
            String sigture = CampmocalHeader + "\n" + afterQuery + "\n" + calculateContentHash;
            String kSecret = this.sk;
            byte[] kheader = this.HmacSHA256(singerDate.getBytes(), kSecret.getBytes());
            byte[] kargs = this.HmacSHA256(this.ak.getBytes(), kheader);
            byte[] kbody = this.HmacSHA256(singerDd.getBytes(), kargs);
            String Signature = Base64.getEncoder().encodeToString(this.HmacSHA256(sigture.getBytes("UTF-8"), kbody));
            String signHeader = String.format("%s Headers=appkey;ctyun-eop-request-id;eop-date Signature=%s", this.ak, Signature);
            return signHeader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CloseableHttpClient sslClient() {
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            return closeableHttpClient;
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doGet(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Response result = new Response();
        try {
            httpClient = this.temp == 0 ? AiSDK.sslClient() : HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(this.url);
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            System.out.println("--------eopDate:" + eopDate);
            httpGet.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpGet.setHeader("ctyun-eop-request-id", this.uuId);
            httpGet.setHeader("Eop-Authorization", this.getSign(eopDate));
            httpGet.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            try {
                URL u = new URL(this.url);
                String host = u.getHost();
                httpGet.setHeader("Host", host);
            }
            catch (Exception u) {
                // empty catch block
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            result.setBody(EntityUtils.toString((HttpEntity)entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public Response sendJsonByGetReq(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        Response result = new Response();
        CloseableHttpClient client = null;
        client = this.temp == 0 ? AiSDK.sslClient() : HttpClients.createDefault();
        HttpGetWithEntity httpGetWithEntity = new HttpGetWithEntity(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
        httpGetWithEntity.setConfig(requestConfig);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpGetWithEntity.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpGetWithEntity.setHeader("ctyun-eop-request-id", this.uuId);
        httpGetWithEntity.setHeader("Eop-Authorization", this.getSign(eopDate));
        httpGetWithEntity.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        try {
            URL u = new URL(this.url);
            String host = u.getHost();
            httpGetWithEntity.setHeader("Host", host);
        }
        catch (Exception u) {
            // empty catch block
        }
        StringEntity httpEntity = new StringEntity(this.body, Charset.forName("UTF-8"));
        httpGetWithEntity.setEntity((HttpEntity)httpEntity);
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpGetWithEntity);
            HttpEntity entity = response.getEntity();
            result.setBody(EntityUtils.toString((HttpEntity)entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPost(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response result = new Response();
        httpClient = this.temp == 0 ? AiSDK.sslClient() : HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
        httpPost.setConfig(requestConfig);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setHeader("ctyun-eop-request-id", this.uuId);
        httpPost.setHeader("Eop-Authorization", this.getSign(eopDate));
        httpPost.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        httpPost.setHeader("appkey", this.appKey);
        try {
            URL u = new URL(this.url);
            String host = u.getHost();
            httpPost.setHeader("Host", host);
        }
        catch (Exception u) {
            // empty catch block
        }
        try {
            StringEntity data = new StringEntity(this.body, Charset.forName("UTF-8"));
            httpPost.setEntity((HttpEntity)data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            result.setBody(EntityUtils.toString((HttpEntity)entity));
            result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doPut(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        Response result = new Response();
        httpClient = this.temp == 0 ? AiSDK.sslClient() : HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
        httpPut.setConfig(requestConfig);
        SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        Date eopDate = new Date();
        httpPut.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPut.setHeader("ctyun-eop-request-id", this.uuId);
        httpPut.setHeader("Eop-Authorization", this.getSign(eopDate));
        httpPut.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
        try {
            URL u = new URL(this.url);
            String host = u.getHost();
            httpPut.setHeader("Host", host);
        }
        catch (Exception u) {
            // empty catch block
        }
        try {
            StringEntity data = new StringEntity(this.body, Charset.forName("UTF-8"));
            httpPut.setEntity((HttpEntity)data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPut);
            HttpEntity entity = httpResponse.getEntity();
            result.setBody(EntityUtils.toString((HttpEntity)entity));
            result.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doDelete(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Response result = new Response();
        try {
            httpClient = this.temp == 0 ? AiSDK.sslClient() : HttpClients.createDefault();
            HttpDelete httpDelete = new HttpDelete(this.url);
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpDelete.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpDelete.setHeader("ctyun-eop-request-id", this.uuId);
            httpDelete.setHeader("Eop-Authorization", this.getSign(eopDate));
            httpDelete.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            try {
                URL u = new URL(this.url);
                String host = u.getHost();
                httpDelete.setHeader("Host", host);
            }
            catch (Exception u) {
                // empty catch block
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
            httpDelete.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpDelete);
            HttpEntity entity = response.getEntity();
            result.setBody(EntityUtils.toString((HttpEntity)entity));
            result.setStatusCode(response.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doHead(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Response result = new Response();
        try {
            httpClient = this.temp == 0 ? AiSDK.sslClient() : HttpClients.createDefault();
            HttpHead httpHead = new HttpHead(this.url);
            SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            Date eopDate = new Date();
            httpHead.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpHead.setHeader("ctyun-eop-request-id", this.uuId);
            httpHead.setHeader("Eop-Authorization", this.getSign(eopDate));
            httpHead.setHeader("Eop-date", TIME_FORMATTER.format(eopDate));
            try {
                URL u = new URL(this.url);
                String host = u.getHost();
                httpHead.setHeader("Host", host);
            }
            catch (Exception u) {
                // empty catch block
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).build();
            httpHead.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpHead);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result.setBody(EntityUtils.toString((HttpEntity)entity));
            }
            result.setStatusCode(response.getStatusLine().getStatusCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            result.setHeaders(headerMap);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        byte[] var2 = data;
        int var3 = data.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            byte b = var2[var4];
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    private String getSHA256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return this.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException var3) {
            return null;
        }
    }

    private byte[] HmacSHA256(byte[] data, byte[] key) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

