/*
 * Decompiled with CFR 0.152.
 */
package com.ctyun.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;

public class Base64Utils {
    private static Base64.Encoder encoder = Base64.getEncoder();
    private static Base64.Encoder urlEncoder = Base64.getUrlEncoder();
    private static Base64.Decoder decoder = Base64.getDecoder();
    private static Base64.Decoder urlDecoder = Base64.getUrlDecoder();

    public static String getBase64FromImgURL(String url) {
        byte[] data = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            URLConnection connection = new URL(url).openConnection();
            InputStream in = connection.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            data = outStream.toByteArray();
            in.close();
            outStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return encoder.encodeToString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBase64FromImgFile(String imgPath) {
        byte[] data = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(imgPath);
            data = new byte[in.available()];
            in.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return encoder.encodeToString(data);
    }

    public static byte[] base64ToByteArr(String base64str, String fileType) {
        byte[] imageData = null;
        switch (fileType) {
            case "image": {
                imageData = decoder.decode(base64str);
                break;
            }
            case "face_makeup_image": {
                imageData = urlDecoder.decode(base64str);
                break;
            }
            case "audio": {
                imageData = urlDecoder.decode(base64str);
                break;
            }
        }
        return imageData;
    }
}

