package com.ctyun;

import com.ctyun.security.MD5;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import java.util.UUID;

public class CtYunSDK {

    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private String method = METHOD_GET;
    private EbpContext context = new EbpContext();
    private String appKey;
    private String appId;
    private String requestId = UUID.randomUUID().toString();
    private boolean isMd5Sign = false;
    private String connection = "close";

    public CtYunSDK(String appId, String appKey, EbpContext body) {
        this.appId = appId;
        this.appKey = appKey;
        this.context = body;
    }

    public CtYunSDK(String appId, String appKey, ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest) request;
        this.appId = httpServletRequest.getHeader("X-APP-ID");
        this.appKey = httpServletRequest.getHeader("X-APP-KEY");
        this.requestId = httpServletRequest.getHeader("X-Transaction-ID");
        this.context.setClientIp(httpServletRequest.getHeader("ORIG_CLIENT_IP"));
    }


    public String call() {
        if (StringUtils.isBlank(this.appKey)) throw new RuntimeException("appKey不能为空！");
        if (StringUtils.isBlank(this.appId)) throw new RuntimeException("appId不能为空！");
        else {
            String wsUrl = this.context.getRequestUrl();
            this.context.getHeaders().add(new Header("X-APP-ID", this.appId));
            this.context.getHeaders().add(new Header("X-APP-KEY", this.appKey));
            this.context.getHeaders().add(new Header("ORIG_CLIENT_IP", this.context.getClientIp()));
            this.context.getHeaders().add(new Header("X-CTG-Request-ID", this.requestId));
            this.context.getHeaders().add(new Header("Connection", this.connection));
            if (this.isMd5Sign) {
                this.context.getHeaders().add(new Header("md5Sign", MD5.getInstance().getMD532(this.context.getParams())));
            }


            String result;
            if (this.method.equals(METHOD_POST)) {
                result = HttpRequest.sendPost(wsUrl, this.context.getParams(), this.context.getHeaders());
            } else {
                result = HttpRequest.sendGet(wsUrl, this.context.getParams(), this.context.getHeaders());
            }

            result = result.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
            StringBuilder sb = new StringBuilder();
            if (result.contains("<?xml")) {
                sb.append(result.substring(0, result.indexOf("<?xml")));
                sb.append("<![cdata[");
                sb.append(result.substring(result.indexOf("<?xml"), result.indexOf("</xml>") + 6));
                sb.append("]]>");
                sb.append(result.substring(result.indexOf("</xml>") + 6));
            } else {
                JSONObject ro = new JSONObject();
                ro.put("code", 200);
                try {
                    JSONArray array = JSONArray.fromObject(result);
                    ro.put("data", array.toString());
                    sb.append(ro.toString());
                } catch (Exception a) {
                    try {
                        JSONObject data = JSONObject.fromObject(result);
                        ro.put("data", data.toString());
                        sb.append(ro.toString());
                    } catch (Exception e) {
                        if (result.contains("timed out")) {
                            ro.put("code", 408);
                            ro.put("message", "请求超时");
                            sb.append(ro.toString());
                        } else {
                            ro.put("code", 500);
                            ro.put("message", result);
                            sb.append(ro.toString());
                        }
                    }
                }
            }
            return sb.toString();
        }
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMd5Sign(boolean md5Sign) {
        this.isMd5Sign = md5Sign;
    }
}
