package com.ctyun.utils;

import com.ctyun.utils.requestbody.SingleSrcImageBody;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ctyun.enums.Category;
import com.ctyun.enums.MakeupType;
import com.ctyun.utils.requestbody.DuelSrcImageBody;
import com.ctyun.utils.requestbody.MultiSrcImageBody;
import lombok.Getter;
import lombok.Setter;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class RequestUtils {
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static String constructRequestBodyFromMultiOnlineSourcesOfData(List<String> requestDataSources) {
        String[] requestDataSourcesBase64Code = sourcesToBase64CodeArr(requestDataSources);
        MultiSrcBodyOfData multiSrcBodyOfData = new MultiSrcBodyOfData();
        multiSrcBodyOfData.setData(requestDataSourcesBase64Code);
        try {
            return objectMapper.writeValueAsString(multiSrcBodyOfData);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }


    public static String constructRequestBodyFromSingleOnlineSourceOfActionImagedata(String action, String requestDataSource) {
        SingleSrcBodyOfActionImagedata singleSrcBodyOfActionImagedata = new SingleSrcBodyOfActionImagedata();
        singleSrcBodyOfActionImagedata.setAction(action);
        singleSrcBodyOfActionImagedata.setImageData(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcBodyOfActionImagedata);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceForFaceMakeup(String action, String requestDataSource, MakeupType makeupType) {
        SingleSrcBodyForFaceMakeup singleSrcBodyForFaceMakeup = new SingleSrcBodyForFaceMakeup();
        singleSrcBodyForFaceMakeup.setAction(action);
        singleSrcBodyForFaceMakeup.setImageData(sourceToBase64Code(requestDataSource));
        singleSrcBodyForFaceMakeup.setMakeupType(Integer.parseInt(makeupType.toString()));
        try {
            return objectMapper.writeValueAsString(singleSrcBodyForFaceMakeup);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfImg(String requestDataSource) {
        SingleSrcBodyOfImg singleSrcBodyOfImg = new SingleSrcBodyOfImg();
        singleSrcBodyOfImg.setImage(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcBodyOfImg);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfImgArea(String requestDataSource) {
        SingleSrcBodyOfImgArea singleSrcBodyOfImgArea = new SingleSrcBodyOfImgArea();
        singleSrcBodyOfImgArea.setImage(new String[]{sourceToBase64Code(requestDataSource)});
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(new URL(requestDataSource));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        String width = String.valueOf(bufferedImage.getWidth());
        String height = String.valueOf(bufferedImage.getHeight());
        List<String> area = Arrays.asList("0", "0", width, "0", width, height, "0", height);
        String delimiter = ",";
        String areaString = String.join(delimiter, area);
        singleSrcBodyOfImgArea.setArea(areaString);
        try {
            return objectMapper.writeValueAsString(singleSrcBodyOfImgArea);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleLocalSourceOfActionImagedata(String action, String requestDataSource) {
        SingleSrcBodyOfActionImagedata singleSrcBodyOfActionImagedata = new SingleSrcBodyOfActionImagedata();
        singleSrcBodyOfActionImagedata.setAction(action);
        singleSrcBodyOfActionImagedata.setImageData(localSourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcBodyOfActionImagedata);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourcesOfImageContent(String requestDataSource) {
        SingleSrcImageBody singleSrcImageBody = new SingleSrcImageBody();
        singleSrcImageBody.setImageContent(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcImageBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromDuelOnlineSourcesOfImageBase64(List<String> requestDataSources) {
        String[] requestDataSourcesBase64Code = sourcesToBase64CodeArr(requestDataSources);
        DuelSrcImageBody duelSrcImageBody = new DuelSrcImageBody();
        duelSrcImageBody.setImg1Base64(requestDataSourcesBase64Code[0]);
        duelSrcImageBody.setImg2Base64(requestDataSourcesBase64Code[1]);
        try {
            return objectMapper.writeValueAsString(duelSrcImageBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }

    }

    public static String constructRequestBodyFromMultiOnlineSourcesOfImageContent(List<String> requestDataSources) {
        String[] requestDataSourcesBase64Code = sourcesToBase64CodeArr(requestDataSources);
        MultiSrcImageBody multiSrcImageBody = new MultiSrcImageBody();
        int size = requestDataSourcesBase64Code.length;
        Class clz;
        try {
            clz = Class.forName("com.ctyun.utils.requestbody.MultiSrcImageBody");
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < size; i++) {
            int methodIndex = i + 1;
            Method method;
            try {
                method = clz.getDeclaredMethod("setImage" + methodIndex + "Content", String.class);
            } catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                method.invoke(multiSrcImageBody, requestDataSourcesBase64Code[i]);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            } catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return objectMapper.writeValueAsString(multiSrcImageBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleSourceForSuperRes(int ratio, String requestDataSource) {
        SingleSrcSuperResBody singleSrcSuperResBody = new SingleSrcSuperResBody();
        singleSrcSuperResBody.setScaleRatio(ratio);
        singleSrcSuperResBody.setImage(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcSuperResBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleSourceForFaceLiquify(String requestDataSource) {
        SingleSrcFaceLiquifyBody singleSrcFaceLiquifyBody = new SingleSrcFaceLiquifyBody();
        singleSrcFaceLiquifyBody.setImage(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcFaceLiquifyBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfContentData(String requestDataSource) {
        SingleSrcBodyOfContentData singleSrcBodyOfContentData = new SingleSrcBodyOfContentData();
        singleSrcBodyOfContentData.setContentData(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(singleSrcBodyOfContentData);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfData(String requestText) {
        TextBody textBody = new TextBody();
        textBody.setData(requestText);
        try {
            return objectMapper.writeValueAsString(textBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfName(String requestName) {
        TextBodyName textBodyName = new TextBodyName();
        textBodyName.setName(requestName);
        try {
            return objectMapper.writeValueAsString(textBodyName);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfId(int requestId) {
        TextBodyId textBodyId = new TextBodyId();
        textBodyId.setId(requestId);
        try {
            return objectMapper.writeValueAsString(textBodyId);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfFace(String requestDataSource, String DbName, String EntityId) {
        FaceBody faceBody = new FaceBody();
        faceBody.setDbName(DbName);
        faceBody.setEntityId(EntityId);
        faceBody.setImageData(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(faceBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfFaceSearch(String requestDataSource, List<String> DbNames) {
        FaceSearchBody faceSearchBody = new FaceSearchBody();
        faceSearchBody.setDbName(DbNames.toArray(new String[DbNames.size()]));
        faceSearchBody.setImageData(sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString(faceSearchBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfDeleteFace(String DBName, String FaceId) {
        FaceDeleteFaceBody faceDeleteFaceBody = new FaceDeleteFaceBody();
        faceDeleteFaceBody.setDbName(DBName);
        faceDeleteFaceBody.setFaceId(FaceId);
        try {
            return objectMapper.writeValueAsString(faceDeleteFaceBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfFaceEntity(String DbName, String EntityId) {
        FaceEntityBody faceEntityBody = new FaceEntityBody();
        faceEntityBody.setDbName(DbName);
        faceEntityBody.setEntityId(EntityId);
        try {
            return objectMapper.writeValueAsString(faceEntityBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfAddPerson(int DbId, String personName) {
        PersonBody personBody = new PersonBody();
        personBody.setDbId(DbId);
        personBody.setName(personName);
        try {
            return objectMapper.writeValueAsString(personBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfUpdateFaceEntity(String DbName, String EntityId, String newEntityId) {
        FaceUpdateEntityBody faceUpdateEntityBody = new FaceUpdateEntityBody();
        faceUpdateEntityBody.setDbName(DbName);
        faceUpdateEntityBody.setEntityId(EntityId);
        faceUpdateEntityBody.setNewEntityId(newEntityId);
        try {
            return objectMapper.writeValueAsString(faceUpdateEntityBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfListFaceEntities(String DbName) {
        FaceListOfFaceEntitiesBody faceListOfFaceEntitiesBody = new FaceListOfFaceEntitiesBody();
        faceListOfFaceEntitiesBody.setDbName(DbName);
        try {
            return objectMapper.writeValueAsString(faceListOfFaceEntitiesBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfListDatabases(int page, int pageSize) {
        FaceListOfDatabasesBody faceListOfDatabasesBody = new FaceListOfDatabasesBody();
        faceListOfDatabasesBody.setPage(page);
        faceListOfDatabasesBody.setPageSize(pageSize);
        try {
            return objectMapper.writeValueAsString(faceListOfDatabasesBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }


    public static String constructRequestBodyOfListPersons(int DbId, int page, int pageSize) {
        FaceListOfPersonsBody faceListOfPersonsBody = new FaceListOfPersonsBody();
        faceListOfPersonsBody.setDbId(DbId);
        faceListOfPersonsBody.setPage(page);
        faceListOfPersonsBody.setPageSize(pageSize);
        try {
            return objectMapper.writeValueAsString(faceListOfPersonsBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }


    public static String constructRequestBodyOfPerson(int DbId, int personId) {
        FacePersonBody facePersonBody = new FacePersonBody();
        facePersonBody.setDbId(DbId);
        facePersonBody.setPersonId(personId);
        try {
            return objectMapper.writeValueAsString(facePersonBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfAddPersonTrace(List<String> requestDataSources, int DbId, int personId) {
        String[] requestDataSourcesBase64Code = sourcesToBase64CodeArr(requestDataSources);
        FaceAddPersonTraceBody faceAddPersonTraceBody = new FaceAddPersonTraceBody();
        faceAddPersonTraceBody.setDbId(DbId);
        faceAddPersonTraceBody.setPersonId(personId);
        faceAddPersonTraceBody.setImageData(requestDataSourcesBase64Code);
        try {
            return objectMapper.writeValueAsString(faceAddPersonTraceBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfSearchPersonTrace(String requestDataSource, int DbId) {
        String[] requestDataSourceBase64Code = sourcesToBase64CodeArr(Arrays.asList(requestDataSource));
        FaceSearchPersonTraceBody faceSearchPersonTraceBody = new FaceSearchPersonTraceBody();
        faceSearchPersonTraceBody.setDbId(DbId);
        faceSearchPersonTraceBody.setImageData(requestDataSourceBase64Code);
        try {
            return objectMapper.writeValueAsString(faceSearchPersonTraceBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfText(String requestText) {
        TextBodyText textBodyText = new TextBodyText();
        textBodyText.setText(requestText);
        try {
            return objectMapper.writeValueAsString(textBodyText);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfTextCategory(Category category, String requestText) {
        TextBodyDataTextCategory textBodyDataTextCategory = new TextBodyDataTextCategory();
        textBodyDataTextCategory.setText(requestText);
        textBodyDataTextCategory.setCate(String.valueOf(category));
        TextBodyData textBodyData = new TextBodyData();
        textBodyData.setData(textBodyDataTextCategory);
        try {
            return objectMapper.writeValueAsString(textBodyData);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfMultiText(List<String> requestTexts) {
        MultiTextBody multiTextBody = new MultiTextBody();
        multiTextBody.setData(requestTexts.toArray(new String[requestTexts.size()]));
        try {
            return objectMapper.writeValueAsString(multiTextBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyForVoice(String action, String text) {
        TTSBody ttsBody = new TTSBody();
        ttsBody.setAction(action);
        ttsBody.setTextData(text);
        ttsBody.setVoiceType(1);
        ttsBody.setSpeed(1.0f);
        ttsBody.setPitch(1.0f);
        try {
            return objectMapper.writeValueAsString(ttsBody);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String sourceToBase64Code(String dataSource) {
        return Base64Utils.getBase64FromImgURL(dataSource);
    }

    private static String localSourceToBase64Code(String dataSource) {
        return Base64Utils.getBase64FromImgFile(dataSource);
    }

    private static String[] sourcesToBase64CodeArr(List<String> dataSources) {
        return dataSources.stream().map(source -> {
            try {
                return Base64Utils.getBase64FromImgURL(source);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toArray(String[]::new);
    }
}

@Setter
class SingleSrcSuperResBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int scaleRatio;
    @Getter
    private String image;
}

class SingleSrcFaceLiquifyBody {
    @Setter
    @Getter
    private String image;
}

@Setter
class SingleSrcBodyOfContentData {

    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String ContentData;
}

@Getter
@Setter
class MultiSrcBodyOfData {
    private String[] data;
}

@Getter
@Setter
class SingleSrcBodyOfImg {
    private String image;
}

@Getter
@Setter
class SingleSrcBodyOfImgArea {
    private String[] image;
    private String area;
}

@Setter
class SingleSrcBodyOfActionImagedata {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String Action;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String ImageData;
}

@Setter
class SingleSrcBodyForFaceMakeup {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String Action;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String ImageData;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int MakeupType;
}

@Getter
@Setter
class TextBody {
    private String data;
}

@Setter
class TextBodyName {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String Name;
}

@Setter
class TextBodyId {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int Id;
}

@Setter
class TextBodyText {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String Text;
}

@Getter
@Setter
class TextBodyData {
    private TextBodyDataTextCategory data;
}

@Getter
@Setter
class TextBodyDataTextCategory {
    private String text;
    private String cate;
}

@Setter
class FaceBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String ImageData;
    //    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    String TimeStamp;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    String ExtraData;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String DbName;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String EntityId;
}

@Setter
class FaceEntityBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String DbName;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String EntityId;
}

@Setter
class PersonBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int DbId;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String Name;
}

@Setter
class FaceUpdateEntityBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String DbName;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String EntityId;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String NewEntityId;
}

@Setter
class FaceListOfFaceEntitiesBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String DbName;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String Page;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String PageSize;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String Labels;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String EntityIdPrefix;
}

@Setter
class FaceListOfDatabasesBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int Page;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int PageSize;
}

@Setter
class FaceListOfPersonsBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int DbId;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int Page;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int PageSize;
}

@Setter
class FacePersonBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int DbId;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int PersonId;
}

@Setter
class FaceAddPersonTraceBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String[] ImageData;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int DbId;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int PersonId;
}

@Setter
class FaceSearchPersonTraceBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String[] ImageData;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int DbId;
}

@Setter
class FaceSearchBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String ImageData;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String[] DbName;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String StartTime;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String EndTime;
//    @JsonProperty
//    @Getter(onMethod_ = @JsonIgnore)
//    private String TopK;
}

@Setter
class FaceDeleteFaceBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String DbName;
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String FaceId;
}

@Getter
@Setter
class MultiTextBody {
    private String[] data;
}

@Setter
class TTSBody {
    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String Action;

    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private String TextData;

    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private int VoiceType;

    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private float Pitch;

    @JsonProperty
    @Getter(onMethod_ = @JsonIgnore)
    private float Speed;
}