/*
 * Decompiled with CFR 0.152.
 */
package com.ctyun.utils;

import com.ctyun.enums.Category;
import com.ctyun.enums.MakeupType;
import com.ctyun.utils.Base64Utils;
import com.ctyun.utils.FaceAddPersonTraceBody;
import com.ctyun.utils.FaceBody;
import com.ctyun.utils.FaceDeleteFaceBody;
import com.ctyun.utils.FaceEntityBody;
import com.ctyun.utils.FaceListOfDatabasesBody;
import com.ctyun.utils.FaceListOfFaceEntitiesBody;
import com.ctyun.utils.FaceListOfPersonsBody;
import com.ctyun.utils.FacePersonBody;
import com.ctyun.utils.FaceSearchBody;
import com.ctyun.utils.FaceSearchPersonTraceBody;
import com.ctyun.utils.FaceUpdateEntityBody;
import com.ctyun.utils.MultiSrcBodyOfData;
import com.ctyun.utils.MultiTextBody;
import com.ctyun.utils.PersonBody;
import com.ctyun.utils.SingleSrcBodyForFaceMakeup;
import com.ctyun.utils.SingleSrcBodyOfActionImagedata;
import com.ctyun.utils.SingleSrcBodyOfContentData;
import com.ctyun.utils.SingleSrcBodyOfImg;
import com.ctyun.utils.SingleSrcBodyOfImgArea;
import com.ctyun.utils.SingleSrcFaceLiquifyBody;
import com.ctyun.utils.SingleSrcSuperResBody;
import com.ctyun.utils.TTSBody;
import com.ctyun.utils.TextBody;
import com.ctyun.utils.TextBodyData;
import com.ctyun.utils.TextBodyDataTextCategory;
import com.ctyun.utils.TextBodyId;
import com.ctyun.utils.TextBodyName;
import com.ctyun.utils.TextBodyText;
import com.ctyun.utils.requestbody.DuelSrcImageBody;
import com.ctyun.utils.requestbody.MultiSrcImageBody;
import com.ctyun.utils.requestbody.SingleSrcImageBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

public class RequestUtils {
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static String constructRequestBodyFromMultiOnlineSourcesOfData(List<String> requestDataSources) {
        String[] requestDataSourcesBase64Code = RequestUtils.sourcesToBase64CodeArr(requestDataSources);
        MultiSrcBodyOfData multiSrcBodyOfData = new MultiSrcBodyOfData();
        multiSrcBodyOfData.setData(requestDataSourcesBase64Code);
        try {
            return objectMapper.writeValueAsString((Object)multiSrcBodyOfData);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfActionImagedata(String action, String requestDataSource) {
        SingleSrcBodyOfActionImagedata singleSrcBodyOfActionImagedata = new SingleSrcBodyOfActionImagedata();
        singleSrcBodyOfActionImagedata.setAction(action);
        singleSrcBodyOfActionImagedata.setImageData(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcBodyOfActionImagedata);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceForFaceMakeup(String action, String requestDataSource, MakeupType makeupType) {
        SingleSrcBodyForFaceMakeup singleSrcBodyForFaceMakeup = new SingleSrcBodyForFaceMakeup();
        singleSrcBodyForFaceMakeup.setAction(action);
        singleSrcBodyForFaceMakeup.setImageData(RequestUtils.sourceToBase64Code(requestDataSource));
        singleSrcBodyForFaceMakeup.setMakeupType(Integer.parseInt(makeupType.toString()));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcBodyForFaceMakeup);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfImg(String requestDataSource) {
        SingleSrcBodyOfImg singleSrcBodyOfImg = new SingleSrcBodyOfImg();
        singleSrcBodyOfImg.setImage(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcBodyOfImg);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfImgArea(String requestDataSource) {
        BufferedImage bufferedImage;
        SingleSrcBodyOfImgArea singleSrcBodyOfImgArea = new SingleSrcBodyOfImgArea();
        singleSrcBodyOfImgArea.setImage(new String[]{RequestUtils.sourceToBase64Code(requestDataSource)});
        try {
            bufferedImage = ImageIO.read(new URL(requestDataSource));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String width = String.valueOf(bufferedImage.getWidth());
        String height = String.valueOf(bufferedImage.getHeight());
        List<String> area = Arrays.asList("0", "0", width, "0", width, height, "0", height);
        String delimiter = ",";
        String areaString = String.join((CharSequence)delimiter, area);
        singleSrcBodyOfImgArea.setArea(areaString);
        try {
            return objectMapper.writeValueAsString((Object)singleSrcBodyOfImgArea);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleLocalSourceOfActionImagedata(String action, String requestDataSource) {
        SingleSrcBodyOfActionImagedata singleSrcBodyOfActionImagedata = new SingleSrcBodyOfActionImagedata();
        singleSrcBodyOfActionImagedata.setAction(action);
        singleSrcBodyOfActionImagedata.setImageData(RequestUtils.localSourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcBodyOfActionImagedata);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourcesOfImageContent(String requestDataSource) {
        SingleSrcImageBody singleSrcImageBody = new SingleSrcImageBody();
        singleSrcImageBody.setImageContent(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcImageBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromDuelOnlineSourcesOfImageBase64(List<String> requestDataSources) {
        String[] requestDataSourcesBase64Code = RequestUtils.sourcesToBase64CodeArr(requestDataSources);
        DuelSrcImageBody duelSrcImageBody = new DuelSrcImageBody();
        duelSrcImageBody.setImg1Base64(requestDataSourcesBase64Code[0]);
        duelSrcImageBody.setImg2Base64(requestDataSourcesBase64Code[1]);
        try {
            return objectMapper.writeValueAsString((Object)duelSrcImageBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromMultiOnlineSourcesOfImageContent(List<String> requestDataSources) {
        Class<?> clz;
        String[] requestDataSourcesBase64Code = RequestUtils.sourcesToBase64CodeArr(requestDataSources);
        MultiSrcImageBody multiSrcImageBody = new MultiSrcImageBody();
        int size = requestDataSourcesBase64Code.length;
        try {
            clz = Class.forName("com.ctyun.utils.requestbody.MultiSrcImageBody");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < size; ++i) {
            Method method;
            int methodIndex = i + 1;
            try {
                method = clz.getDeclaredMethod("setImage" + methodIndex + "Content", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                method.invoke((Object)multiSrcImageBody, requestDataSourcesBase64Code[i]);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)multiSrcImageBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleSourceForSuperRes(int ratio, String requestDataSource) {
        SingleSrcSuperResBody singleSrcSuperResBody = new SingleSrcSuperResBody();
        singleSrcSuperResBody.setScaleRatio(ratio);
        singleSrcSuperResBody.setImage(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcSuperResBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleSourceForFaceLiquify(String requestDataSource) {
        SingleSrcFaceLiquifyBody singleSrcFaceLiquifyBody = new SingleSrcFaceLiquifyBody();
        singleSrcFaceLiquifyBody.setImage(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcFaceLiquifyBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyFromSingleOnlineSourceOfContentData(String requestDataSource) {
        SingleSrcBodyOfContentData singleSrcBodyOfContentData = new SingleSrcBodyOfContentData();
        singleSrcBodyOfContentData.setContentData(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)singleSrcBodyOfContentData);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfData(String requestText) {
        TextBody textBody = new TextBody();
        textBody.setData(requestText);
        try {
            return objectMapper.writeValueAsString((Object)textBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfName(String requestName) {
        TextBodyName textBodyName = new TextBodyName();
        textBodyName.setName(requestName);
        try {
            return objectMapper.writeValueAsString((Object)textBodyName);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfId(int requestId) {
        TextBodyId textBodyId = new TextBodyId();
        textBodyId.setId(requestId);
        try {
            return objectMapper.writeValueAsString((Object)textBodyId);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfFace(String requestDataSource, String DbName, String EntityId) {
        FaceBody faceBody = new FaceBody();
        faceBody.setDbName(DbName);
        faceBody.setEntityId(EntityId);
        faceBody.setImageData(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)faceBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfFaceSearch(String requestDataSource, List<String> DbNames) {
        FaceSearchBody faceSearchBody = new FaceSearchBody();
        faceSearchBody.setDbName(DbNames.toArray(new String[DbNames.size()]));
        faceSearchBody.setImageData(RequestUtils.sourceToBase64Code(requestDataSource));
        try {
            return objectMapper.writeValueAsString((Object)faceSearchBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfDeleteFace(String DBName, String FaceId) {
        FaceDeleteFaceBody faceDeleteFaceBody = new FaceDeleteFaceBody();
        faceDeleteFaceBody.setDbName(DBName);
        faceDeleteFaceBody.setFaceId(FaceId);
        try {
            return objectMapper.writeValueAsString((Object)faceDeleteFaceBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfFaceEntity(String DbName, String EntityId) {
        FaceEntityBody faceEntityBody = new FaceEntityBody();
        faceEntityBody.setDbName(DbName);
        faceEntityBody.setEntityId(EntityId);
        try {
            return objectMapper.writeValueAsString((Object)faceEntityBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfAddPerson(int DbId, String personName) {
        PersonBody personBody = new PersonBody();
        personBody.setDbId(DbId);
        personBody.setName(personName);
        try {
            return objectMapper.writeValueAsString((Object)personBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfUpdateFaceEntity(String DbName, String EntityId, String newEntityId) {
        FaceUpdateEntityBody faceUpdateEntityBody = new FaceUpdateEntityBody();
        faceUpdateEntityBody.setDbName(DbName);
        faceUpdateEntityBody.setEntityId(EntityId);
        faceUpdateEntityBody.setNewEntityId(newEntityId);
        try {
            return objectMapper.writeValueAsString((Object)faceUpdateEntityBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfListFaceEntities(String DbName) {
        FaceListOfFaceEntitiesBody faceListOfFaceEntitiesBody = new FaceListOfFaceEntitiesBody();
        faceListOfFaceEntitiesBody.setDbName(DbName);
        try {
            return objectMapper.writeValueAsString((Object)faceListOfFaceEntitiesBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfListDatabases(int page, int pageSize) {
        FaceListOfDatabasesBody faceListOfDatabasesBody = new FaceListOfDatabasesBody();
        faceListOfDatabasesBody.setPage(page);
        faceListOfDatabasesBody.setPageSize(pageSize);
        try {
            return objectMapper.writeValueAsString((Object)faceListOfDatabasesBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfListPersons(int DbId, int page, int pageSize) {
        FaceListOfPersonsBody faceListOfPersonsBody = new FaceListOfPersonsBody();
        faceListOfPersonsBody.setDbId(DbId);
        faceListOfPersonsBody.setPage(page);
        faceListOfPersonsBody.setPageSize(pageSize);
        try {
            return objectMapper.writeValueAsString((Object)faceListOfPersonsBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfPerson(int DbId, int personId) {
        FacePersonBody facePersonBody = new FacePersonBody();
        facePersonBody.setDbId(DbId);
        facePersonBody.setPersonId(personId);
        try {
            return objectMapper.writeValueAsString((Object)facePersonBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfAddPersonTrace(List<String> requestDataSources, int DbId, int personId) {
        String[] requestDataSourcesBase64Code = RequestUtils.sourcesToBase64CodeArr(requestDataSources);
        FaceAddPersonTraceBody faceAddPersonTraceBody = new FaceAddPersonTraceBody();
        faceAddPersonTraceBody.setDbId(DbId);
        faceAddPersonTraceBody.setPersonId(personId);
        faceAddPersonTraceBody.setImageData(requestDataSourcesBase64Code);
        try {
            return objectMapper.writeValueAsString((Object)faceAddPersonTraceBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfSearchPersonTrace(String requestDataSource, int DbId) {
        String[] requestDataSourceBase64Code = RequestUtils.sourcesToBase64CodeArr(Arrays.asList(requestDataSource));
        FaceSearchPersonTraceBody faceSearchPersonTraceBody = new FaceSearchPersonTraceBody();
        faceSearchPersonTraceBody.setDbId(DbId);
        faceSearchPersonTraceBody.setImageData(requestDataSourceBase64Code);
        try {
            return objectMapper.writeValueAsString((Object)faceSearchPersonTraceBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfText(String requestText) {
        TextBodyText textBodyText = new TextBodyText();
        textBodyText.setText(requestText);
        try {
            return objectMapper.writeValueAsString((Object)textBodyText);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfTextCategory(Category category, String requestText) {
        TextBodyDataTextCategory textBodyDataTextCategory = new TextBodyDataTextCategory();
        textBodyDataTextCategory.setText(requestText);
        textBodyDataTextCategory.setCate(String.valueOf((Object)category));
        TextBodyData textBodyData = new TextBodyData();
        textBodyData.setData(textBodyDataTextCategory);
        try {
            return objectMapper.writeValueAsString((Object)textBodyData);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyOfMultiText(List<String> requestTexts) {
        MultiTextBody multiTextBody = new MultiTextBody();
        multiTextBody.setData(requestTexts.toArray(new String[requestTexts.size()]));
        try {
            return objectMapper.writeValueAsString((Object)multiTextBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructRequestBodyForVoice(String action, String text) {
        TTSBody ttsBody = new TTSBody();
        ttsBody.setAction(action);
        ttsBody.setTextData(text);
        ttsBody.setVoiceType(1);
        ttsBody.setSpeed(1.0f);
        ttsBody.setPitch(1.0f);
        try {
            return objectMapper.writeValueAsString((Object)ttsBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String sourceToBase64Code(String dataSource) {
        return Base64Utils.getBase64FromImgURL(dataSource);
    }

    private static String localSourceToBase64Code(String dataSource) {
        return Base64Utils.getBase64FromImgFile(dataSource);
    }

    private static String[] sourcesToBase64CodeArr(List<String> dataSources) {
        return (String[])dataSources.stream().map(source -> {
            try {
                return Base64Utils.getBase64FromImgURL(source);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toArray(String[]::new);
    }
}

