/*
 * Decompiled with CFR 0.152.
 */
package io.github.daflamingfox;

import io.github.daflamingfox.CmdExecutor;
import io.github.daflamingfox.SlashCmd;
import io.github.daflamingfox.SlashCmdEventManager;
import io.github.daflamingfox.TxtCmd;
import io.github.daflamingfox.TxtCmdEventManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.server.Server;
import org.javacord.api.interaction.SlashCommandOption;
import org.javacord.api.interaction.SlashCommandPermissions;
import org.javacord.api.listener.interaction.SlashCommandCreateListener;
import org.javacord.api.listener.message.MessageCreateListener;

public class CmdHandlerBuilder {
    private ArrayList<TxtCmd> textCmds;
    private ArrayList<SlashCmd> slashCmds;
    private String prefix;
    private DiscordApi api;

    public CmdHandlerBuilder(DiscordApi api, String prefix) {
        this.api = api;
        this.prefix = prefix == null ? "!" : prefix;
        this.textCmds = new ArrayList();
        this.slashCmds = new ArrayList();
    }

    public CmdHandlerBuilder addTextCommand(String keyword, String[] keywordAliases, String description, String usage, CmdExecutor executor) {
        TxtCmd cmd = new TxtCmd(this.prefix, keyword, keywordAliases, executor, this.api, description == null ? "No description." : description, usage == null ? "No usage." : usage);
        this.textCmds.add(cmd);
        return this;
    }

    public CmdHandlerBuilder addSlashCommand(String name, String description, List<SlashCommandOption> options, List<SlashCommandPermissions> permissions, Server server, CmdExecutor executor) {
        SlashCmd cmd = new SlashCmd(name, description == null ? "No description." : description, options == null ? Optional.empty() : Optional.of(options), permissions == null ? Optional.empty() : Optional.of(permissions), server == null ? Optional.empty() : Optional.of(server), executor);
        this.slashCmds.add(cmd);
        return this;
    }

    public void build() {
        this.textCmds.forEach(cmd -> this.api.addMessageCreateListener((MessageCreateListener)new TxtCmdEventManager((TxtCmd)cmd)));
        this.slashCmds.forEach(cmd -> this.api.addSlashCommandCreateListener((SlashCommandCreateListener)new SlashCmdEventManager(this.api, (SlashCmd)cmd)));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ArrayList<TxtCmd> getTextCommands() {
        return this.textCmds;
    }

    public ArrayList<SlashCmd> getSlashCommands() {
        return this.slashCmds;
    }
}

