/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.manipulation;

import io.github.danielnaczo.python3parser.Python3Lexer;
import io.github.danielnaczo.python3parser.Python3Parser;
import io.github.danielnaczo.python3parser.model.AST;
import io.github.danielnaczo.python3parser.model.Identifier;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.FunctionDef;
import io.github.danielnaczo.python3parser.visitors.ast.ModuleVisitor;
import io.github.danielnaczo.python3parser.visitors.modifier.ModifierVisitor;
import io.github.danielnaczo.python3parser.visitors.prettyprint.IndentationPrettyPrint;
import io.github.danielnaczo.python3parser.visitors.prettyprint.ModulePrettyPrintVisitor;
import java.io.IOException;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class RenameFunctionsManipulation {
    public static void main(String[] args) throws IOException {
        CharStream charStream = CharStreams.fromFileName((String)"trunk/examples/Elevator.py");
        Python3Lexer lexer = new Python3Lexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Python3Parser parser = new Python3Parser((TokenStream)tokens);
        ModuleVisitor moduleVisitor = new ModuleVisitor();
        AST ast = (AST)moduleVisitor.visit((ParseTree)parser.file_input());
        String functionPrefix = "go";
        RenameFunctionModifier renameFunctionModifier = new RenameFunctionModifier();
        Object modifiedAST = renameFunctionModifier.visitAST(ast, functionPrefix);
        ModulePrettyPrintVisitor modulePrettyPrintVisitor = new ModulePrettyPrintVisitor();
        String string = modulePrettyPrintVisitor.visitAST((AST)modifiedAST, new IndentationPrettyPrint(0));
        System.out.println(string);
    }

    private static class RenameFunctionModifier
    extends ModifierVisitor<String> {
        private RenameFunctionModifier() {
        }

        @Override
        public AST visitFunctionDef(FunctionDef functionDef, String functionPrefix) {
            super.visitFunctionDef(functionDef, functionPrefix);
            if (functionDef.getName().getName().equals("up") || functionDef.getName().getName().equals("down")) {
                String currentFunctionName = functionDef.getName().getName();
                String newFunctionName = functionPrefix + Character.toUpperCase(currentFunctionName.charAt(0)) + currentFunctionName.substring(1);
                Identifier newIdentifier = new Identifier(newFunctionName);
                functionDef.setName(newIdentifier);
            }
            return functionDef;
        }
    }
}

