/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.mods;

import io.github.danielnaczo.python3parser.model.mods.Mod;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.ClassDef;
import io.github.danielnaczo.python3parser.model.stmts.compoundStmts.functionStmts.FunctionDef;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import io.github.danielnaczo.python3parser.visitors.prettyprint.IndentationPrettyPrint;
import io.github.danielnaczo.python3parser.visitors.prettyprint.ModulePrettyPrintVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Module
extends Mod {
    private List<Statement> statements;

    public Module() {
        this.statements = new ArrayList<Statement>();
    }

    public Module(List<Statement> body) {
        this.statements = body;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public Statement addStatement(Statement statement) {
        this.statements.add(statement);
        return statement;
    }

    public void addStatements(List<Statement> statements) {
        for (Statement statement : statements) {
            statements.add(statement);
        }
    }

    public ClassDef addClass(ClassDef clazz) {
        this.addStatement(clazz);
        return clazz;
    }

    public FunctionDef addFunction(FunctionDef function) {
        this.addStatement(function);
        return function;
    }

    public List<ClassDef> getClassDefs() {
        ArrayList<ClassDef> classes = new ArrayList<ClassDef>();
        for (Statement statement : this.statements) {
            if (!(statement instanceof ClassDef)) continue;
            classes.add((ClassDef)statement);
        }
        return classes;
    }

    public List<FunctionDef> getFunctionDefs() {
        ArrayList<FunctionDef> functions = new ArrayList<FunctionDef>();
        for (Statement statement : this.statements) {
            if (!(statement instanceof FunctionDef)) continue;
            functions.add((FunctionDef)statement);
        }
        return functions;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitModule(this, param);
    }

    public void printInConsole() {
        ModulePrettyPrintVisitor modulePrettyPrintVisitor = new ModulePrettyPrintVisitor();
        String prettyprintedString = modulePrettyPrintVisitor.visitModule(this, new IndentationPrettyPrint(0));
        System.out.println(prettyprintedString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return Objects.equals(this.statements, module.statements);
    }

    public int hashCode() {
        return Objects.hash(this.statements);
    }
}

